/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.PrefixFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class PrefixFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(list);
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.INSENSITIVE, list);
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.SENSITIVE, list);
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() throws FileSystemException {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"test"});
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() throws FileSystemException {
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.INSENSITIVE, new String[]{"test"});
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() throws FileSystemException {
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.SENSITIVE, new String[]{"test"});
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assert.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

