/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4s.test;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http4.Http4FileProvider;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.http4s.Http4sFileProvider;
import org.junit.Assert;
import org.junit.Test;

public class Http4sGetContentInfoTest
extends TestCase {
    protected void setUp() throws Exception {
        DefaultFileSystemManager manager = (DefaultFileSystemManager)VFS.getManager();
        if (!manager.hasProvider("http4")) {
            manager.addProvider("http4", (FileProvider)new Http4FileProvider());
        }
        if (!manager.hasProvider("http4s")) {
            manager.addProvider("http4s", (FileProvider)new Http4sFileProvider());
        }
    }

    @Test
    public void testGetContentInfo() throws FileSystemException, MalformedURLException {
        FileSystemOptions opts;
        String httpsProxyHost = null;
        int httpsProxyPort = -1;
        String httpsProxy = System.getenv("https_proxy");
        if (httpsProxy != null) {
            URL url = new URL(httpsProxy);
            httpsProxyHost = url.getHost();
            httpsProxyPort = url.getPort();
        }
        if (httpsProxyHost != null) {
            opts = new FileSystemOptions();
            Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
            builder.setProxyHost(opts, httpsProxyHost);
            if (httpsProxyPort >= 0) {
                builder.setProxyPort(opts, httpsProxyPort);
            }
        } else {
            opts = null;
        }
        FileSystemManager fsManager = VFS.getManager();
        FileObject fo = fsManager.resolveFile("http4://www.apache.org/licenses/LICENSE-2.0.txt", opts);
        FileContent content = fo.getContent();
        Assert.assertNotNull((Object)content);
        content.getContentInfo();
    }
}

