/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res.test;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Test;

public class ResSchemeTestCase {
    @Test
    public void test_resolveFile_String() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile("res:test.properties").exists());
    }

    @Test
    public void test_resolveFile_String_S() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile("res:/test.properties").exists());
    }

    @Test
    public void test_resolveFile_String_SS() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile("res://test.properties").exists());
    }

    @Test
    public void test_resolveFile_String_SSS() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile("res://test.properties").exists());
    }

    @Test
    public void test_resolveFile_URI() throws FileSystemException, URISyntaxException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res:test.properties")).exists());
    }

    @Test
    public void test_resolveFile_URI_S() throws FileSystemException, URISyntaxException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res:/test.properties")).exists());
    }

    @Test
    public void test_resolveFile_URI_SS() throws FileSystemException, URISyntaxException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res://test.properties")).exists());
    }

    @Test
    public void test_resolveFile_URI_SSS() throws FileSystemException, URISyntaxException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile(new URI("res://test.properties")).exists());
    }

    @Test
    public void test_resolveURI_String() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveURI("res:test.properties").isFile());
    }

    @Test
    public void test_resolveURI_String_S() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveURI("res:/test.properties").isFile());
    }

    @Test
    public void test_resolveURI_String_SS() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveURI("res://test.properties").isFile());
    }

    @Test
    public void test_resolveURI_String_SSS() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveURI("res:///test.properties").isFile());
    }

    @Test(expected=FileSystemException.class)
    public void test_resolveURI_String_SSSnull() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveURI("res:///").isFile());
    }

    @Test(expected=FileSystemException.class)
    public void test_resolveFile_String_SSSnull() throws FileSystemException {
        Assert.assertTrue((boolean)VFS.getManager().resolveFile("res:///").exists());
    }
}

