/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res.test;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;
import org.junit.Assert;

public class Vfs444TestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        ProviderTestSuite suite = new ProviderTestSuite(new Vfs444TestCase(), true);
        suite.addTests(Vfs444Tests.class);
        return suite;
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("res", (FileProvider)new ResourceFileProvider());
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String baseDir = AbstractVfsTestCase.getResourceTestDirectory();
        return manager.resolveFile("zip:res:" + baseDir + "/test.zip");
    }

    public static class Vfs444Tests
    extends AbstractProviderTestCase {
        public void testResolveFullPathURI0() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:test-data/test.zip");
            Assert.assertTrue((boolean)result.isFile());
        }

        public void testResolveFullPathFile0() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res:test-data/test.zip");
            Assert.assertTrue((boolean)result.exists());
        }

        public void testResolveFullPathURI1() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:/test-data/test.zip");
            Assert.assertTrue((boolean)result.isFile());
        }

        public void testResolveFullPathFile1() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res:/test-data/test.zip");
            Assert.assertTrue((boolean)result.exists());
        }

        public void testResolveFullPathURI2() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res://test-data/test.zip");
            Assert.assertTrue((boolean)result.isFile());
        }

        public void testResolveFullPathFile2() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res://test-data/test.zip");
            Assert.assertTrue((boolean)result.exists());
        }

        public void testResolvePartialPath1() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:test-data");
            Assert.assertTrue((boolean)result.isFile());
        }

        public void testResolvePartialPath2() throws FileSystemException {
            FileName root = this.getManager().resolveURI("res:test-data");
            FileName file = this.getManager().resolveName(root, "test.zip");
            String uri = file.getURI();
            FileObject result = this.getManager().resolveFile(uri);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.exists());
        }
    }
}

