/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.zip.test.TestEntityResolver;
import org.apache.commons.vfs2.provider.zip.test.TestErrorHandler;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ParseXmlInZipTestCase {
    private File createTempFile() throws IOException {
        File zipFile = new File("src/test/resources/test-data/read-xml-tests.zip");
        File newZipFile = File.createTempFile(this.getClass().getSimpleName(), ".zip");
        newZipFile.deleteOnExit();
        FileUtils.copyFile((File)zipFile, (File)newZipFile);
        return newZipFile;
    }

    private DocumentBuilder newDocumentBuilder(FileObject containerFile, FileObject sourceFile, String pathToXsdInZip) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean validate = pathToXsdInZip != null;
        documentBuilderFactory.setValidating(validate);
        documentBuilderFactory.setNamespaceAware(true);
        if (validate) {
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            FileObject schema = containerFile.resolveFile(pathToXsdInZip);
            if (schema.exists()) {
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schema.getContent().getInputStream());
            } else {
                schema.close();
                throw new FileNotFoundException(schema.toString());
            }
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new TestEntityResolver(containerFile, sourceFile));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot read Java Connector configuration: " + e, e);
        }
        documentBuilder.setErrorHandler(new TestErrorHandler(containerFile + " - " + sourceFile));
        return documentBuilder;
    }

    @Test
    public void testParseXmlInZip() throws IOException, SAXException {
        File newZipFile = this.createTempFile();
        String xmlFilePath = "zip:file:" + newZipFile.getAbsolutePath() + "!/read-xml-tests/file1.xml";
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile(xmlFilePath);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            Document document = this.newDocumentBuilder(zipFileObject, zipFileObject, null).parse(inputStream);
            Assert.assertNotNull((Object)document);
        }
    }

    @Test
    public void testResolveAndParseBiggerXmlInZip() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/file3-bigger.xml", null);
    }

    @Test
    public void testResolveAndParseInvalidXml() throws IOException, SAXException {
        try {
            this.testResolveAndParseXmlInZip("read-xml-tests/name-invalid.xml", "/read-xml-tests/name.xsd");
        }
        catch (SAXException e) {
            Pattern p = Pattern.compile("Invalid content was found starting with element.+FOO");
            Assert.assertTrue((boolean)p.matcher(e.toString()).find());
        }
    }

    @Test
    public void testResolveAndParseNotWellFormedXml() throws IOException {
        try {
            this.testResolveAndParseXmlInZip("read-xml-tests/name-not-well-formed.xml", "/read-xml-tests/name.xsd");
        }
        catch (SAXException e) {
            Assert.assertTrue((boolean)e.toString().contains("XML document structures must start and end within the same entity."));
        }
    }

    @Test
    public void testResolveAndParseXmlInZip() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/file1.xml", null);
    }

    private void testResolveAndParseXmlInZip(String xmlPathInZip, String xsdPathInZip) throws IOException, FileSystemException, SAXException {
        File newZipFile = this.createTempFile();
        String zipFilePath = "zip:file:" + newZipFile.getAbsolutePath();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile(zipFilePath);
             FileObject xmlFileObject = zipFileObject.resolveFile(xmlPathInZip);
             InputStream inputStream = xmlFileObject.getContent().getInputStream();){
            Document document = this.newDocumentBuilder(zipFileObject, xmlFileObject, xsdPathInZip).parse(inputStream);
            Assert.assertNotNull((Object)document);
        }
    }

    @Test
    public void testResolveAndParseXmlInZipWithOneXmlSchema() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/name-with-xsd-ref.xml", "/read-xml-tests/name.xsd");
    }

    @Test
    public void testResolveAndParseXmlInZipWithTwoXmlSchema() throws IOException, SAXException {
        this.testResolveAndParseXmlInZip("read-xml-tests/person.xml", "/read-xml-tests/person.xsd");
    }
}

