/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.test.FileInfo;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.junit.Assert;

public abstract class AbstractProviderTestCase
extends AbstractVfsTestCase {
    private FileObject baseFolder;
    private FileObject readFolder;
    private FileObject writeFolder;
    private DefaultFileSystemManager manager;
    private ProviderTestConfig providerConfig;
    private Method method;
    private boolean addEmptyDir;
    public static final String FILE1_CONTENT = "This is a test file.";
    public static final String TEST_FILE_CONTENT = "A test file.";

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setConfig(DefaultFileSystemManager manager, ProviderTestConfig providerConfig, FileObject baseFolder, FileObject readFolder, FileObject writeFolder) {
        this.manager = manager;
        this.providerConfig = providerConfig;
        this.baseFolder = baseFolder;
        this.readFolder = readFolder;
        this.writeFolder = writeFolder;
        AbstractProviderTestCase.assertNotNull((String)"setConfig manager", (Object)manager);
        AbstractProviderTestCase.assertNotNull((String)"setConfig providerConfig", (Object)providerConfig);
        AbstractProviderTestCase.assertNotNull((String)"setConfig baseFolder", (Object)baseFolder);
        AbstractProviderTestCase.assertNotNull((String)"setConfig readFolder", (Object)readFolder);
        AbstractProviderTestCase.assertNotNull((String)"setConfig writeFolder", (Object)writeFolder);
    }

    protected DefaultFileSystemManager getManager() {
        return this.manager;
    }

    protected DefaultFileSystemManager createManager() throws Exception {
        DefaultFileSystemManager fs = this.getProviderConfig().getDefaultFileSystemManager();
        fs.setFilesCache(this.getProviderConfig().getFilesCache());
        this.getProviderConfig().prepare(fs);
        if (!fs.hasProvider("file")) {
            fs.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        }
        return fs;
    }

    public FileObject getBaseTestFolder(FileSystemManager fs) throws Exception {
        return this.providerConfig.getBaseTestFolder(fs);
    }

    protected FileSystem getFileSystem() {
        FileObject rFolder = this.getReadFolder();
        Assert.assertNotNull((String)"This test's read folder should not be null", (Object)rFolder);
        return rFolder.getFileSystem();
    }

    public FileObject getBaseFolder() {
        return this.baseFolder;
    }

    public ProviderTestConfig getProviderConfig() {
        return this.providerConfig;
    }

    protected FileObject getReadFolder() {
        return this.readFolder;
    }

    protected FileObject getWriteFolder() {
        return this.writeFolder;
    }

    protected void setWriteFolder(FileObject folder) {
        this.writeFolder = folder;
    }

    protected Capability[] getRequiredCaps() {
        return null;
    }

    protected void runTest() throws Throwable {
        Capability[] caps = this.getRequiredCaps();
        if (caps != null) {
            Capability[] capabilityArray = caps;
            int n = capabilityArray.length;
            for (int i = 0; i < n; ++i) {
                Capability cap2;
                Capability cap = cap2 = capabilityArray[i];
                FileSystem fs = this.getFileSystem();
                if (fs.hasCapability(cap)) continue;
                return;
            }
        }
        if (this.method != null) {
            try {
                this.method.invoke((Object)this, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        } else {
            super.runTest();
        }
        if (((AbstractFileSystem)this.readFolder.getFileSystem()).isOpen()) {
            String name = "unknown";
            if (this.method != null) {
                name = this.method.getName();
            }
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + ": filesystem has open streams after: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameURLContent(String expected, URLConnection connection) throws Exception {
        ByteArrayOutputStream outstr;
        byte[] expectedBin = expected.getBytes("utf-8");
        AbstractProviderTestCase.assertEquals((String)"same content length", (int)expectedBin.length, (int)connection.getContentLength());
        try (InputStream instr = connection.getInputStream();){
            outstr = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            int nread = 0;
            while (nread >= 0) {
                outstr.write(buffer, 0, nread);
                nread = instr.read(buffer);
            }
        }
        AbstractProviderTestCase.assertTrue((String)"same binary content", (boolean)Arrays.equals(expectedBin, outstr.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameContent(String expected, FileObject file) throws Exception {
        ByteArrayOutputStream outstr;
        AbstractProviderTestCase.assertTrue((boolean)file.exists());
        AbstractProviderTestCase.assertSame((Object)FileType.FILE, (Object)file.getType());
        AbstractProviderTestCase.assertTrue((boolean)file.isFile());
        byte[] expectedBin = expected.getBytes("utf-8");
        FileContent content = file.getContent();
        AbstractProviderTestCase.assertEquals((String)"same content length", (long)expectedBin.length, (long)content.getSize());
        try (InputStream instr = content.getInputStream();){
            outstr = new ByteArrayOutputStream(expectedBin.length);
            byte[] buffer = new byte[256];
            int nread = 0;
            while (nread >= 0) {
                outstr.write(buffer, 0, nread);
                nread = instr.read(buffer);
            }
        }
        AbstractProviderTestCase.assertTrue((String)"same binary content", (boolean)Arrays.equals(expectedBin, outstr.toByteArray()));
    }

    protected FileInfo buildExpectedStructure() throws FileSystemException {
        FileInfo base = new FileInfo(this.getReadFolder().getName().getBaseName(), FileType.FOLDER);
        base.addFile("file1.txt", FILE1_CONTENT);
        base.addFile("file%25.txt", FILE1_CONTENT);
        base.addFile("file space.txt", FILE1_CONTENT);
        base.addFile("empty.txt", "");
        if (this.addEmptyDir) {
            base.addFolder("emptydir");
        }
        FileInfo dir = base.addFolder("dir1");
        dir.addFile("file1.txt", TEST_FILE_CONTENT);
        dir.addFile("file2.txt", TEST_FILE_CONTENT);
        dir.addFile("file3.txt", TEST_FILE_CONTENT);
        FileInfo subdir1 = dir.addFolder("subdir1");
        subdir1.addFile("file1.txt", TEST_FILE_CONTENT);
        subdir1.addFile("file2.txt", TEST_FILE_CONTENT);
        subdir1.addFile("file3.txt", TEST_FILE_CONTENT);
        FileInfo subdir2 = dir.addFolder("subdir2");
        subdir2.addFile("file1.txt", TEST_FILE_CONTENT);
        subdir2.addFile("file2.txt", TEST_FILE_CONTENT);
        subdir2.addFile("file3.txt", TEST_FILE_CONTENT);
        FileInfo subdir3 = dir.addFolder("subdir3");
        subdir3.addFile("file1.txt", TEST_FILE_CONTENT);
        subdir3.addFile("file2.txt", TEST_FILE_CONTENT);
        subdir3.addFile("file3.txt", TEST_FILE_CONTENT);
        FileInfo subdir4 = dir.addFolder("subdir4.jar");
        subdir4.addFile("file1.txt", TEST_FILE_CONTENT);
        subdir4.addFile("file2.txt", TEST_FILE_CONTENT);
        subdir4.addFile("file3.txt", TEST_FILE_CONTENT);
        return base;
    }

    protected void addEmptyDir(boolean addEmptyDir) {
        this.addEmptyDir = addEmptyDir;
    }

    protected static Test notConfigured(Class<?> testClass) {
        return AbstractProviderTestCase.warning(testClass + " is not configured for tests, skipping");
    }

    private static Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                System.out.println(message);
            }
        };
    }

    public String toString() {
        return "AbstractProviderTestCase [baseFolder=" + this.baseFolder + ", readFolder=" + this.readFolder + ", writeFolder=" + this.writeFolder + ", manager=" + this.manager + ", providerConfig=" + this.providerConfig + ", method=" + this.method + ", addEmptyDir=" + this.addEmptyDir + "]";
    }
}

