/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileObjectUtilsTest {
    private void assertProperties(Properties p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"1", (Object)p.getProperty("one"));
        Assert.assertEquals((Object)"2", (Object)p.getProperty("two"));
    }

    @Test
    public void testExistsNotNull() throws FileSystemException {
        Assert.assertTrue((boolean)FileObjectUtils.exists((FileObject)VFS.getManager().toFileObject(SystemUtils.getJavaIoTmpDir())));
    }

    @Test
    public void testgetContentAsString_Charset() throws FileSystemException, IOException {
        Assert.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testgetContentAsString_CharsetNull() throws FileSystemException, IOException {
        Assert.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (Charset)null));
    }

    @Test
    public void testgetContentAsString_String() throws FileSystemException, IOException {
        Assert.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (String)"UTF-8"));
    }

    @Test
    public void testgetContentAsString_StringNull() throws FileSystemException, IOException {
        Assert.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (String)null));
    }

    @Test
    public void testNotExistsNotNull() throws FileSystemException {
        Assert.assertFalse((boolean)FileObjectUtils.exists((FileObject)VFS.getManager().toFileObject(new File("This file can't possibly exist, right?"))));
    }

    @Test
    public void testNotExistsNull() throws FileSystemException {
        Assert.assertFalse((boolean)FileObjectUtils.exists(null));
    }

    @Test
    public void testReadProperties() throws FileSystemException, IOException {
        this.assertProperties(FileObjectUtils.readProperties((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test.properties"))));
    }

    @Test
    public void testReadPropertiesInto() throws FileSystemException, IOException {
        Properties p = new Properties();
        p.setProperty("extraKey", "extraValue");
        this.assertProperties(FileObjectUtils.readProperties((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test.properties")), (Properties)p));
        Assert.assertEquals((Object)"extraValue", (Object)p.getProperty("extraKey"));
    }
}

