/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.vfs2.FileExtensionSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileExtensionSelectorTest {
    private static FileObject BaseFolder;
    private static final int FileCount = 9;
    private static final int ExtensionCount = 3;
    private static final int FilesPerExtensionCount = 3;

    @BeforeClass
    public static void setUpClass() throws Exception {
        BaseFolder = VFS.getManager().resolveFile("ram://" + FileExtensionSelectorTest.class.getName());
        BaseFolder.deleteAll();
        BaseFolder.createFolder();
        BaseFolder.resolveFile("a.htm").createFile();
        BaseFolder.resolveFile("a.html").createFile();
        BaseFolder.resolveFile("a.xhtml").createFile();
        BaseFolder.resolveFile("b.htm").createFile();
        BaseFolder.resolveFile("b.html").createFile();
        BaseFolder.resolveFile("b.xhtml").createFile();
        BaseFolder.resolveFile("c.htm").createFile();
        BaseFolder.resolveFile("c.html").createFile();
        BaseFolder.resolveFile("c.xhtml").createFile();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (BaseFolder != null) {
            BaseFolder.deleteAll();
        }
    }

    @Test
    public void testEmpty() throws Exception {
        FileExtensionSelector selector = new FileExtensionSelector(new String[0]);
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector);
        Assert.assertEquals((long)0L, (long)foList.length);
    }

    @Test
    public void testManyExtensions() throws Exception {
        FileObject[] foArray = BaseFolder.findFiles(Selectors.SELECT_FILES);
        Assert.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assert.assertTrue((String)message, (extensionSet.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)message, (long)3L, (long)extensionSet.size());
        FileExtensionSelector selector = new FileExtensionSelector(extensionSet);
        FileObject[] list = BaseFolder.findFiles((FileSelector)selector);
        Assert.assertEquals((long)9L, (long)list.length);
    }

    @Test
    public void testNullCollection() throws Exception {
        FileExtensionSelector selector0 = new FileExtensionSelector((Collection)null);
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector0);
        Assert.assertEquals((long)0L, (long)foList.length);
    }

    @Test
    public void testNullString() throws Exception {
        FileExtensionSelector selector0 = new FileExtensionSelector(new String[]{null});
        FileObject[] foList = BaseFolder.findFiles((FileSelector)selector0);
        Assert.assertEquals((long)0L, (long)foList.length);
    }

    @Test
    public void testOneExtension() throws Exception {
        FileObject[] foArray = BaseFolder.findFiles(Selectors.SELECT_FILES);
        Assert.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assert.assertEquals((String)message, (long)3L, (long)extensionSet.size());
        for (String extension : extensionSet) {
            FileExtensionSelector selector = new FileExtensionSelector(new String[]{extension});
            FileObject[] list = BaseFolder.findFiles((FileSelector)selector);
            Assert.assertEquals((long)3L, (long)list.length);
        }
        for (FileObject fo : foArray) {
            FileExtensionSelector selector = new FileExtensionSelector(new String[]{fo.getName().getExtension()});
            FileObject[] list = BaseFolder.findFiles((FileSelector)selector);
            Assert.assertEquals((long)3L, (long)list.length);
        }
    }
}

