/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.AbstractFilesCacheTestsBase;
import org.apache.commons.vfs2.cache.NullFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.junit.Assert;

public class NullFilesCacheTests
extends AbstractFilesCacheTestsBase {
    public void testFilesCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        Assert.assertNotNull((String)"This test should not have a null FileObject scratch folder", (Object)scratchFolder);
        FileObject dir1 = scratchFolder.resolveFile("dir1");
        FileObject dir1_2 = scratchFolder.resolveFile("dir1");
        NullFilesCacheTests.assertNotSame((String)"Should always be new instance with NullCache", (Object)dir1, (Object)dir1_2);
    }

    @Override
    public void testBasicCacheOps() throws Exception {
        DefaultFileSystemManager manager = this.getManager();
        Assert.assertNotNull((String)"This test should not have a null DefaultFileSystemManager", (Object)manager);
        FilesCache cache = manager.getFilesCache();
        FileObject fo = this.getWriteFolder().resolveFile("dir1");
        FileName fn = fo.getName();
        FileSystem fs = fo.getFileSystem();
        cache.clear(fs);
        NullFilesCacheTests.assertNull((Object)cache.getFile(fs, fn));
        cache.putFile(fo);
        NullFilesCacheTests.assertNull(null, (Object)cache.getFile(fs, fn));
        NullFilesCacheTests.assertFalse((boolean)cache.putFileIfAbsent(fo));
        NullFilesCacheTests.assertNull(null, (Object)cache.getFile(fs, fn));
        cache.removeFile(fs, fn);
        NullFilesCacheTests.assertNull((Object)cache.getFile(fs, fn));
    }

    public void testClass() {
        DefaultFileSystemManager manager = this.getManager();
        Assert.assertNotNull((String)"This test should not have a null DefaultFileSystemManager", (Object)manager);
        NullFilesCacheTests.assertTrue((boolean)(manager.getFilesCache() instanceof NullFilesCache));
    }
}

