/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl.test;

import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.junit.Ignore;

public class DefaultFileMonitorTest
extends AbstractVfsTestCase {
    private FileSystemManager fsManager;
    private File testDir;
    private int changeStatus = 0;
    private File testFile;

    public void setUp() throws Exception {
        super.setUp();
        this.fsManager = VFS.getManager();
        this.testDir = AbstractVfsTestCase.getTestDirectoryFile();
        this.changeStatus = 0;
        this.testFile = new File(this.testDir, "testReload.properties");
        if (this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    public void tearDown() throws Exception {
        if (this.testFile != null) {
            this.testFile.deleteOnExit();
        }
        super.tearDown();
    }

    public void testFileCreated() throws Exception {
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)"Incorrect event", (int)3, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    public void testFileDeleted() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.testFile.delete();
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)"Incorrect event", (int)2, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileModified() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            Thread.sleep(1000L);
            long value = System.currentTimeMillis();
            boolean rc = this.testFile.setLastModified(value);
            DefaultFileMonitorTest.assertTrue((String)"setLastModified succeeded", (boolean)rc);
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)"Incorrect event", (int)1, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    public void testFileRecreated() throws Exception {
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)("Incorrect event " + this.changeStatus), (int)3, (int)this.changeStatus);
            this.changeStatus = 0;
            this.testFile.delete();
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)("Incorrect event " + this.changeStatus), (int)2, (int)this.changeStatus);
            this.changeStatus = 0;
            Thread.sleep(500L);
            monitor.addFile(fileObj);
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)("Incorrect event " + this.changeStatus), (int)3, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    public void testChildFileRecreated() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testDir.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(2000L);
        monitor.setRecursive(true);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.changeStatus = 0;
            Thread.sleep(300L);
            this.testFile.delete();
            Thread.sleep(3000L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)("Incorrect event " + this.changeStatus), (int)2, (int)this.changeStatus);
            this.changeStatus = 0;
            Thread.sleep(300L);
            this.writeToFile(this.testFile);
            Thread.sleep(3000L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)("Incorrect event " + this.changeStatus), (int)3, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    public void testChildFileDeletedWithoutRecursiveChecking() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testDir.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(2000L);
        monitor.setRecursive(false);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.changeStatus = 0;
            Thread.sleep(300L);
            this.testFile.delete();
            Thread.sleep(3000L);
            DefaultFileMonitorTest.assertEquals((String)"Event should not have occurred", (int)0, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    public void testFileMonitorRestarted() throws Exception {
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        this.writeToFile(this.testFile);
        Thread.sleep(300L);
        monitor.stop();
        monitor.start();
        try {
            this.testFile.delete();
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTest.assertEquals((String)"Incorrect event", (int)2, (int)this.changeStatus);
        }
        finally {
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    public void ignore_testAddRemove() throws Exception {
        FileObject file = this.fsManager.resolveFile(this.testFile.toURI().toString());
        CountingListener listener = new CountingListener();
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)listener);
        monitor.setDelay(100L);
        try {
            monitor.addFile(file);
            monitor.removeFile(file);
            monitor.addFile(file);
            monitor.start();
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTest.assertEquals((String)"Created event is only fired once", (long)1L, (long)listener.created.get());
        }
        finally {
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    public void ignore_testStartStop() throws Exception {
        FileObject file = this.fsManager.resolveFile(this.testFile.toURI().toString());
        CountingListener stoppedListener = new CountingListener();
        DefaultFileMonitor stoppedMonitor = new DefaultFileMonitor((FileListener)stoppedListener);
        stoppedMonitor.start();
        stoppedMonitor.addFile(file);
        stoppedMonitor.stop();
        CountingListener activeListener = new CountingListener();
        DefaultFileMonitor activeMonitor = new DefaultFileMonitor((FileListener)activeListener);
        activeMonitor.setDelay(100L);
        activeMonitor.addFile(file);
        activeMonitor.start();
        try {
            this.writeToFile(this.testFile);
            Thread.sleep(1000L);
            DefaultFileMonitorTest.assertEquals((String)"The listener of the active monitor received one created event", (long)1L, (long)activeListener.created.get());
            DefaultFileMonitorTest.assertEquals((String)"The listener of the stopped monitor received no events", (long)0L, (long)stoppedListener.created.get());
        }
        finally {
            activeMonitor.stop();
        }
    }

    private void writeToFile(File file) throws Exception {
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.close();
    }

    public class TestFileListener
    implements FileListener {
        public void fileChanged(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = 1;
        }

        public void fileDeleted(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = 2;
        }

        public void fileCreated(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = 3;
        }
    }

    private static class CountingListener
    implements FileListener {
        private final AtomicLong created = new AtomicLong();

        private CountingListener() {
        }

        public void fileCreated(FileChangeEvent event) {
            this.created.incrementAndGet();
        }

        public void fileDeleted(FileChangeEvent event) {
            throw new UnsupportedOperationException();
        }

        public void fileChanged(FileChangeEvent event) {
            throw new UnsupportedOperationException();
        }
    }
}

