/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class VfsClassLoaderTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.READ_CONTENT, Capability.URI};
    }

    private VFSClassLoader createClassLoader() throws FileSystemException {
        FileObject file = this.getBaseFolder();
        return new VFSClassLoader(file, (FileSystemManager)this.getManager());
    }

    public void testLoadClass() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.ClassToLoad");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code", (String)pack.getName());
        this.verifyPackage(pack, false);
        Object testObject = testClass.newInstance();
        VfsClassLoaderTests.assertEquals((String)"**PRIVATE**", (String)testObject.toString());
    }

    public void testLoadResource() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource("read-tests/file1.txt");
        VfsClassLoaderTests.assertNotNull((Object)resource);
        URLConnection urlCon = resource.openConnection();
        this.assertSameURLContent("This is a test file.", urlCon);
    }

    public void testSealing() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.sealed.AnotherClass");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code.sealed", (String)pack.getName());
        this.verifyPackage(pack, true);
    }

    public void testGetResourcesJARs() throws Exception {
        DefaultFileSystemManager manager = this.getManager();
        try {
            manager.toFileObject(new File("."));
        }
        catch (FileSystemException e) {
            System.out.println("VfsClassLoaderTests no local file provider, skipping.");
            return;
        }
        File baseDir = AbstractVfsTestCase.getTestDirectoryFile();
        FileObject nestedJar = manager.resolveFile(baseDir, "nested.jar");
        FileObject testJar = manager.resolveFile(baseDir, "test.jar");
        if (!manager.canCreateFileSystem(nestedJar)) {
            System.out.println("VfsClassLoaderTests no layered .jar provider, skipping.");
            return;
        }
        VfsClassLoaderTests.assertSame((String)"nested.jar is required for testing", (Object)nestedJar.getType(), (Object)FileType.FILE);
        VfsClassLoaderTests.assertSame((String)"test.jar is required for testing", (Object)testJar.getType(), (Object)FileType.FILE);
        MockClassloader mockClassloader = new MockClassloader();
        FileObject[] search = new FileObject[]{nestedJar, testJar};
        VFSClassLoader loader = new VFSClassLoader(search, (FileSystemManager)this.getManager(), (ClassLoader)mockClassloader);
        Enumeration urls = loader.getResources("META-INF/MANIFEST.MF");
        URL url1 = (URL)urls.nextElement();
        URL url2 = (URL)urls.nextElement();
        VfsClassLoaderTests.assertTrue((String)("First resource must refer to nested.jar but was " + url1), (boolean)url1.toString().endsWith("nested.jar!/META-INF/MANIFEST.MF"));
        VfsClassLoaderTests.assertTrue((String)("Second resource must refer to test.jar but was " + url2), (boolean)url2.toString().endsWith("test.jar!/META-INF/MANIFEST.MF"));
    }

    public void testGetResourcesNoLayerLocal() throws Exception {
        DefaultFileSystemManager manager = this.getManager();
        try {
            manager.toFileObject(new File("."));
        }
        catch (FileSystemException e) {
            System.out.println("VfsClassLoaderTests no local file provider, skipping.");
            return;
        }
        File baseDir = AbstractVfsTestCase.getTestDirectoryFile();
        FileObject dir = manager.resolveFile(baseDir, "read-tests/dir1/subdir4.jar");
        VfsClassLoaderTests.assertSame((String)("subdir4.jar/ is required for testing " + dir), (Object)dir.getType(), (Object)FileType.FOLDER);
        VfsClassLoaderTests.assertFalse((boolean)manager.canCreateFileSystem(dir));
        FileObject[] search = new FileObject[]{dir};
        MockClassloader mockClassloader = new MockClassloader();
        VFSClassLoader loader = new VFSClassLoader(search, (FileSystemManager)this.getManager(), (ClassLoader)mockClassloader);
        Enumeration urls = loader.getResources("file1.txt");
        URL url1 = (URL)urls.nextElement();
        VfsClassLoaderTests.assertFalse((String)"Only one hit expected", (boolean)urls.hasMoreElements());
        VfsClassLoaderTests.assertTrue((String)("not pointing to resource " + url1), (boolean)url1.toString().endsWith("subdir4.jar/file1.txt"));
    }

    private void verifyPackage(Package pack, boolean sealed) {
        if (this.getBaseFolder().getFileSystem().hasCapability(Capability.MANIFEST_ATTRIBUTES)) {
            VfsClassLoaderTests.assertEquals((String)"ImplTitle", (String)pack.getImplementationTitle());
            VfsClassLoaderTests.assertEquals((String)"ImplVendor", (String)pack.getImplementationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.1", (String)pack.getImplementationVersion());
            VfsClassLoaderTests.assertEquals((String)"SpecTitle", (String)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertEquals((String)"SpecVendor", (String)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.0", (String)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertEquals((boolean)sealed, (boolean)pack.isSealed());
        } else {
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVersion());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertFalse((boolean)pack.isSealed());
        }
    }

    public static class MockClassloader
    extends ClassLoader {
        MockClassloader() {
            super(null);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return Collections.enumeration(Collections.emptyList());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            TestCase.fail((String)"Not intended to be used for class loading.");
            return null;
        }
    }
}

