/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileContentTest {
    private static final String expected = "testing";

    @Test
    public void testGetZeroContents() throws IOException {
        FileSystemManager fsManager = VFS.getManager();
        try (FileObject fo = fsManager.resolveFile(new File("."), "src/test/resources/test-data/size-0-file.bin");
             FileContent content = fo.getContent();){
            Assert.assertEquals((long)0L, (long)content.getSize());
            Assert.assertTrue((boolean)content.isEmpty());
            Assert.assertEquals((Object)"", (Object)content.getString(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)"", (Object)content.getString(StandardCharsets.UTF_8.name()));
            Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])content.getByteArray());
        }
    }

    private void testInputStreamBufferSize(int bufferSize) throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getInputStream(bufferSize);
        }
    }

    @Test
    public void testInputStreamBufferSize0() throws Exception {
        this.testInputStreamBufferSize(0);
    }

    @Test
    public void testInputStreamBufferSize1() throws Exception {
        this.testInputStreamBufferSize(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputStreamBufferSizeNegative() throws Exception {
        this.testInputStreamBufferSize(-2);
    }

    @Test
    public void testMarkingWhenReadingEOS() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            var6_8 = null;
            try (InputStream stream = file.getContent().getInputStream();){
                int readCount = 0;
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        readCount = stream.read(data, 0, 7);
                        stream.read();
                        Assert.assertEquals((long)7L, (long)readCount);
                        Assert.assertEquals((Object)expected, (Object)new String(data).trim());
                        readCount = stream.read(data, 8, 10);
                        Assert.assertEquals((long)-1L, (long)readCount);
                        stream.reset();
                    }
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testMarkingWorks() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            var6_8 = null;
            try (InputStream stream = file.getContent().getInputStream();){
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        stream.read(data, 0, 7);
                        stream.read();
                        Assert.assertEquals((Object)expected, (Object)new String(data).trim());
                        stream.reset();
                    }
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    private void testOutputStreamBufferSize(int bufferSize) throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getOutputStream(bufferSize).close();
        }
    }

    @Test
    public void testOutputStreamBufferSize0() throws Exception {
        this.testOutputStreamBufferSize(0);
    }

    @Test
    public void testOutputStreamBufferSize1() throws Exception {
        this.testOutputStreamBufferSize(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputStreamBufferSizeNegative() throws Exception {
        this.testOutputStreamBufferSize(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputStreamBufferSizeNegativeWithAppendFlag() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getOutputStream(true, -1);
        }
    }
}

