/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class ProviderRandomReadTests
extends AbstractProviderTestCase {
    private static final String TEST_DATA = "This is a test file.";

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.RANDOM_ACCESS_READ};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomRead() throws Exception {
        try (FileObject file = null;){
            file = this.getReadFolder().resolveFile("file1.txt");
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READ);
            byte c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(0), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)1L, (long)ra.getFilePointer());
            ra.seek(3L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(3), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)4L, (long)ra.getFilePointer());
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(4), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)5L, (long)ra.getFilePointer());
            ra.seek(3L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(3), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)4L, (long)ra.getFilePointer());
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(4), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)5L, (long)ra.getFilePointer());
            ra.seek(10L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(10), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)11L, (long)ra.getFilePointer());
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)TEST_DATA.charAt(11), (int)c);
            ProviderRandomReadTests.assertEquals((String)"fp", (long)12L, (long)ra.getFilePointer());
        }
    }
}

