/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.IOException;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.junit.Assert;

public class ProviderRandomSetLengthTests
extends AbstractProviderTestCase {
    private static final String TEST_DATA = "This is a test file.";

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE, Capability.RANDOM_ACCESS_SET_LENGTH};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomSetLength() throws Exception {
        try (FileObject file = null;){
            file = this.createScratchFolder().resolveFile("random_write.txt");
            file.createFile();
            String fileString = file.toString();
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READWRITE);
            ra.writeBytes(TEST_DATA);
            Assert.assertEquals((String)fileString, (long)TEST_DATA.length(), (long)ra.length());
            ra.setLength(1L);
            Assert.assertEquals((String)fileString, (long)1L, (long)ra.length());
            ra.seek(0L);
            Assert.assertEquals((String)fileString, (long)TEST_DATA.charAt(0), (long)ra.readByte());
            try {
                ra.readByte();
                Assert.fail((String)("Expected " + Exception.class.getName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ra.setLength(2L);
            Assert.assertEquals((String)fileString, (long)2L, (long)ra.length());
            ra.seek(1L);
            ra.readByte();
        }
    }
}

