/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class UrlTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.URI};
    }

    public void testURL() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("some-dir/");
        URL url = file.getURL();
        UrlTests.assertEquals((String)file.getName().getURI(), (String)url.toExternalForm());
        URL parentURL = new URL(url, "..");
        UrlTests.assertEquals((Object)file.getParent().getURL(), (Object)parentURL);
        URL rootURL = new URL(url, "/");
        UrlTests.assertEquals((Object)file.getFileSystem().getRoot().getURL(), (Object)rootURL);
    }

    public void testURLContent() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        UrlTests.assertTrue((boolean)file.exists());
        URLConnection urlCon = file.getURL().openConnection();
        this.assertSameURLContent("This is a test file.", urlCon);
        file = this.getReadFolder().resolveFile("empty.txt");
        UrlTests.assertTrue((boolean)file.exists());
        urlCon = file.getURL().openConnection();
        this.assertSameURLContent("", urlCon);
    }

    public void testURLContentProvider() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        UrlTests.assertTrue((boolean)file.exists());
        String uri = file.getURL().toExternalForm();
        FileSystemOptions options = this.getReadFolder().getFileSystem().getFileSystemOptions();
        FileObject f1 = this.getManager().resolveFile(uri, options);
        FileObject f2 = this.getManager().resolveFile(uri, options);
        UrlTests.assertEquals((String)("Two files resolved by URI must be equals on " + uri), (Object)f1, (Object)f2);
        UrlTests.assertSame((String)("Resolving two times should not produce new filesystem on " + uri), (Object)f1.getFileSystem(), (Object)f2.getFileSystem());
    }

    public void testUnknownURL() throws Exception {
        FileObject unknownFile = this.getReadFolder().resolveFile("unknown-file");
        UrlTests.assertFalse((boolean)unknownFile.exists());
        URLConnection connection = unknownFile.getURL().openConnection();
        try {
            connection.getInputStream();
            UrlTests.fail();
        }
        catch (IOException e) {
            UrlTests.assertSameMessage("vfs.provider/read-not-file.error", unknownFile, (Throwable)e);
        }
        UrlTests.assertEquals((int)-1, (int)connection.getContentLength());
    }
}

