/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.UserAuthenticationData;
import org.junit.Assert;
import org.junit.Test;

public class UserAuthenticationDataTestCase {
    @Test
    public void testCharacterBasedData() {
        UserAuthenticationData data = new UserAuthenticationData();
        char[] array = "PMC".toCharArray();
        data.setData(UserAuthenticationData.USERNAME, array);
        data.setData(UserAuthenticationData.DOMAIN, "Apache".toCharArray());
        Assert.assertSame((Object)array, (Object)data.getData(UserAuthenticationData.USERNAME));
        Assert.assertArrayEquals((char[])"Apache".toCharArray(), (char[])data.getData(UserAuthenticationData.DOMAIN));
        data.setData(UserAuthenticationData.DOMAIN, "Apache Commons".toCharArray());
        Assert.assertArrayEquals((char[])"Apache Commons".toCharArray(), (char[])data.getData(UserAuthenticationData.DOMAIN));
        Assert.assertNull((Object)data.getData(UserAuthenticationData.PASSWORD));
        data.cleanup();
        Assert.assertNull((Object)data.getData(UserAuthenticationData.USERNAME));
        Assert.assertNull((Object)data.getData(UserAuthenticationData.DOMAIN));
        char[] nulls = new char[]{'\u0000', '\u0000', '\u0000'};
        Assert.assertArrayEquals((char[])nulls, (char[])array);
    }

    @Test
    public void testCustomType() {
        UserAuthenticationData.Type type = new UserAuthenticationData.Type("JUNIT");
        UserAuthenticationData data = new UserAuthenticationData();
        char[] array = "test".toCharArray();
        data.setData(type, array);
        Assert.assertSame((Object)array, (Object)data.getData(type));
    }
}

