/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.CanExecuteFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class CanExecuteFileFilterTest
extends BaseFilterTest {
    private static final String EXECUTABLE = "executable.txt";
    private static final String NOT_EXECUTABLE = "notexecutable.txt";
    private static File testDir;
    private static File executableFile;
    private static FileSelectInfo executableFileInfo;
    private static File notExecutableFile;
    private static FileSelectInfo notExecutableFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = CanExecuteFileFilterTest.getTestDir(CanExecuteFileFilterTest.class.getName());
        executableFile = new File(testDir, EXECUTABLE);
        executableFileInfo = CanExecuteFileFilterTest.createFileSelectInfo(executableFile);
        FileUtils.touch((File)executableFile);
        executableFile.setExecutable(true);
        notExecutableFile = new File(testDir, NOT_EXECUTABLE);
        notExecutableFileInfo = CanExecuteFileFilterTest.createFileSelectInfo(notExecutableFile);
        FileUtils.touch((File)notExecutableFile);
        notExecutableFile.setExecutable(false);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = CanExecuteFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(CanExecuteFileFilterTest.getTempDir(), CanExecuteFileFilterTest.class.getName() + ".zip");
        CanExecuteFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = CanExecuteFileFilterTest.getZipFileObject(zipFile);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        executableFileInfo = null;
        executableFile.delete();
        executableFile = null;
        notExecutableFileInfo = null;
        notExecutableFile.delete();
        notExecutableFile = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @Test
    public void testAcceptCanExecute() throws FileSystemException {
        Assert.assertTrue((boolean)CanExecuteFileFilter.CAN_EXECUTE.accept(executableFileInfo));
        Assert.assertTrue((boolean)CanExecuteFileFilter.CAN_EXECUTE.accept(notExecutableFileInfo));
        Assert.assertFalse((boolean)CanExecuteFileFilter.CAN_EXECUTE.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptCannotExecute() throws FileSystemException {
        Assert.assertFalse((boolean)CanExecuteFileFilter.CANNOT_EXECUTE.accept(executableFileInfo));
        Assert.assertFalse((boolean)CanExecuteFileFilter.CANNOT_EXECUTE.accept(notExecutableFileInfo));
        Assert.assertTrue((boolean)CanExecuteFileFilter.CANNOT_EXECUTE.accept(notExistingFileInfo));
    }
}

