/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.WildcardFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class WildcardFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(list);
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.INSENSITIVE, list);
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() throws FileSystemException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("*.txt");
        list.add("*.a??");
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.SENSITIVE, list);
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() throws FileSystemException {
        WildcardFileFilter filter = new WildcardFileFilter(new String[]{"*.txt", "*.a??"});
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() throws FileSystemException {
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.INSENSITIVE, new String[]{"*.txt", "*.a??"});
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() throws FileSystemException {
        WildcardFileFilter filter = new WildcardFileFilter(IOCase.SENSITIVE, new String[]{"*.txt", "*.a??"});
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.a"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ab"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abc"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.ABC"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aaa"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.Aaa"))));
        Assert.assertTrue((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.aAA"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.abcd"))));
        Assert.assertFalse((boolean)filter.accept(WildcardFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

