/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp.test;

import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.junit.Assert;

public class FtpProviderTestCase
extends AbstractProviderTestConfig {
    private static int SocketPort;
    private static String ConnectionUri;
    private static FtpServer Server;
    private static final String TEST_URI = "test.ftp.uri";
    private static final String USER_PROPS_RES = "org.apache.ftpserver/users.properties";

    static String getConnectionUri() {
        return ConnectionUri;
    }

    static int getSocketPort() {
        return SocketPort;
    }

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    static void setUpClass(String rootDirectory, FileSystemFactory fileSystemFactory) throws FtpException, IOException {
        if (Server != null) {
            return;
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        PropertiesUserManagerFactory propertiesUserManagerFactory = new PropertiesUserManagerFactory();
        URL userPropsResource = ClassLoader.getSystemClassLoader().getResource(USER_PROPS_RES);
        Assert.assertNotNull((String)USER_PROPS_RES, (Object)userPropsResource);
        propertiesUserManagerFactory.setUrl(userPropsResource);
        UserManager userManager = propertiesUserManagerFactory.createUserManager();
        BaseUser user = (BaseUser)userManager.getUserByName("test");
        user.setHomeDirectory(rootDirectory);
        userManager.save((User)user);
        serverFactory.setUserManager(userManager);
        if (fileSystemFactory != null) {
            serverFactory.setFileSystem(fileSystemFactory);
        }
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(0);
        serverFactory.addListener("default", factory.createListener());
        Server = serverFactory.createServer();
        Server.start();
        SocketPort = ((DefaultFtpServer)Server).getListener("default").getPort();
        ConnectionUri = "ftp://test:test@localhost:" + SocketPort;
    }

    public static Test suite() throws Exception {
        return FtpProviderTestCase.suite(new FtpProviderTestCase());
    }

    protected static Test suite(final FtpProviderTestCase testCase) throws Exception {
        return new ProviderTestSuite((ProviderTestConfig)testCase){

            @Override
            protected void setUp() throws Exception {
                if (FtpProviderTestCase.getSystemTestUriOverride() == null) {
                    FtpProviderTestCase.setUpClass(testCase.getFtpRootDir(), testCase.getFtpFileSystem());
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                try {
                    super.tearDown();
                }
                finally {
                    FtpProviderTestCase.tearDownClass();
                }
            }
        };
    }

    static void tearDownClass() {
        if (Server != null) {
            Server.stop();
            Server = null;
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = FtpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        FileSystemOptions opts = new FileSystemOptions();
        FtpFileSystemConfigBuilder builder = FtpFileSystemConfigBuilder.getInstance();
        builder.setUserDirIsRoot(opts, this.getUserDirIsRoot());
        builder.setPassiveMode(opts, true);
        builder.setFileType(opts, FtpFileType.BINARY);
        builder.setConnectTimeout(opts, Integer.valueOf(10000));
        builder.setControlEncoding(opts, "UTF-8");
        return manager.resolveFile(uri, opts);
    }

    protected boolean getUserDirIsRoot() {
        return false;
    }

    protected FileSystemFactory getFtpFileSystem() throws IOException {
        return null;
    }

    protected String getFtpRootDir() {
        return FtpProviderTestCase.getTestDirectory();
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftp", (FileProvider)new FtpFileProvider());
    }
}

