/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4.test;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.junit.Assert;
import org.junit.Test;

public class Http4GetContentInfoTest
extends TestCase {
    @Test
    public void testGetContentInfo() throws FileSystemException, MalformedURLException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http4://www.apache.org/licenses/LICENSE-2.0.txt";
        FileObject fo = fsManager.resolveFile("http4://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithProxy());
        FileContent content = fo.getContent();
        Assert.assertNotNull((Object)content);
        content.getContentInfo();
    }

    FileSystemOptions getOptionsWithProxy() throws MalformedURLException {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUrl = System.getenv("https_proxy");
        if (proxyUrl != null) {
            URL url = new URL(proxyUrl);
            proxyHost = url.getHost();
            proxyPort = url.getPort();
        }
        if (proxyHost == null || proxyPort == -1) {
            return null;
        }
        Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = new FileSystemOptions();
        builder.setProxyHost(opts, proxyHost);
        builder.setProxyPort(opts, proxyPort);
        builder.setProxyScheme(opts, "http");
        return opts;
    }
}

