/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.https.test;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.junit.Assert;
import org.junit.Test;

public class GetContentInfoFunctionalTest {
    @Test
    public void testGetContentInfo() throws FileSystemException, MalformedURLException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http://www.apache.org/licenses/LICENSE-2.0.txt";
        try (FileObject fo = fsManager.resolveFile("http://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithProxy());
             FileContent content = fo.getContent();){
            Assert.assertNotNull((Object)content);
            content.getContentInfo();
        }
    }

    FileSystemOptions getOptionsWithProxy() throws MalformedURLException {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUrl = System.getenv("https_proxy");
        if (proxyUrl != null) {
            URL url = new URL(proxyUrl);
            proxyHost = url.getHost();
            proxyPort = url.getPort();
        }
        if (proxyHost == null || proxyPort == -1) {
            return null;
        }
        HttpFileSystemConfigBuilder builder = HttpFileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = new FileSystemOptions();
        builder.setProxyHost(opts, proxyHost);
        builder.setProxyPort(opts, proxyPort);
        return opts;
    }
}

