/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp.test;

import com.jcraft.jsch.TestIdentityRepositoryFactory;
import com.jcraft.jsch.UserInfo;
import java.net.URI;
import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.commons.vfs2.provider.sftp.test.AbstractSftpProviderTestCase;
import org.apache.commons.vfs2.test.PermissionsTests;
import org.apache.commons.vfs2.test.ProviderReadTests;

public class SftpProviderStreamProxyModeTestCase
extends AbstractSftpProviderTestCase {
    @Override
    protected boolean isExecChannelClosed() {
        return false;
    }

    public static Test suite() throws Exception {
        AbstractSftpProviderTestCase.SftpProviderTestSuite suite = new AbstractSftpProviderTestCase.SftpProviderTestSuite(new SftpProviderStreamProxyModeTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                this.addTests(ProviderReadTests.class);
                this.addTests(PermissionsTests.class);
            }
        };
        return suite;
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = SftpProviderStreamProxyModeTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        builder.setStrictHostKeyChecking(fileSystemOptions, "no");
        builder.setUserInfo(fileSystemOptions, (UserInfo)new TrustEveryoneUserInfo());
        builder.setIdentityRepositoryFactory(fileSystemOptions, (IdentityRepositoryFactory)new TestIdentityRepositoryFactory());
        FileSystemOptions proxyOptions = (FileSystemOptions)fileSystemOptions.clone();
        URI parsedURI = new URI(uri);
        String userInfo = parsedURI.getUserInfo();
        String[] userFields = userInfo == null ? null : userInfo.split(":", 2);
        builder.setProxyType(fileSystemOptions, SftpFileSystemConfigBuilder.PROXY_STREAM);
        if (userFields != null) {
            if (userFields.length > 0) {
                builder.setProxyUser(fileSystemOptions, userFields[0]);
            }
            if (userFields.length > 1) {
                builder.setProxyPassword(fileSystemOptions, userFields[1]);
            }
        }
        builder.setProxyHost(fileSystemOptions, parsedURI.getHost());
        builder.setProxyPort(fileSystemOptions, parsedURI.getPort());
        builder.setProxyCommand(fileSystemOptions, "nc -q 0 %s %d");
        builder.setProxyOptions(fileSystemOptions, proxyOptions);
        builder.setProxyPassword(fileSystemOptions, parsedURI.getAuthority());
        uri = userInfo == null ? String.format("sftp://localhost:%d", parsedURI.getPort()) : String.format("sftp://%s@localhost:%d", userInfo, parsedURI.getPort());
        FileObject fileObject = manager.resolveFile(uri, fileSystemOptions);
        this.fileSystem = (SftpFileSystem)fileObject.getFileSystem();
        return fileObject;
    }
}

