/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar.test;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Test;

public class TarFileObjectTestCase {
    @Test
    public void testReadSpecialNameFileInTarFile() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tar", "tar");
    }

    @Test
    public void testReadSpecialNameFileInTgzFile() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tgz", "tgz");
    }

    @Test
    public void testReadSpecialNameFileInTbz2File() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tbz2", "tbz2");
    }

    private void testReadSpecialNameFileInFile(String testFilePath, String scheme) throws FileSystemException {
        File testFile = new File(testFilePath);
        String[] fileNames = new String[]{"file.txt", "file^.txt", "file~.txt", "file?.txt", "file@.txt", "file$.txt", "file*.txt", "file&.txt", "file#.txt", "file%.txt", "file!.txt"};
        FileSystemManager manager = VFS.getManager();
        String baseUrl = scheme + ":file:" + testFile.getAbsolutePath();
        try (FileObject fileObject = manager.resolveFile(baseUrl);){
            Assert.assertEquals((long)fileObject.getChildren().length, (long)fileNames.length);
            for (String fileName : fileNames) {
                Assert.assertNotNull((String)("can't read file " + fileName), (Object)fileObject.getChild(fileName));
            }
        }
    }
}

