/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.util.Date;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.junit.Assert;
import org.junit.Test;

public class LastModifiedTests
extends AbstractProviderTestCase {
    private void assertDelta(String message, long expected, long actual, long delta) {
        if (expected == actual) {
            return;
        }
        if (Math.abs(expected - actual) > Math.max(delta, 1000L)) {
            Assert.fail((String)String.format("%s expected=%d (%s), actual=%d (%s), delta=%d", message, expected, new Date(expected).toString(), actual, new Date(actual).toString(), delta));
        }
    }

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_LAST_MODIFIED};
    }

    @Test
    public void testGetAccurary() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        long lastModTimeAccuracy = (long)file.getFileSystem().getLastModTimeAccuracy();
        LastModifiedTests.assertTrue((String)"Accuracy must be positive", (lastModTimeAccuracy >= 0L ? 1 : 0) != 0);
        LastModifiedTests.assertTrue((String)"Accuracy must be < 2m", (lastModTimeAccuracy < 120000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetLastModifiedFolder() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("dir1");
        Assert.assertNotEquals((long)0L, (long)file.getContent().getLastModifiedTime());
    }

    @Test
    public void testGetLastModifiedFile() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        Assert.assertNotEquals((long)0L, (long)file.getContent().getLastModifiedTime());
    }

    @Test
    public void testSetLastModifiedFolder() throws FileSystemException {
        long yesterday = System.currentTimeMillis() - 86400000L;
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) {
            FileObject folder = this.getReadFolder().resolveFile("dir1");
            folder.getContent().setLastModifiedTime(yesterday);
            long lastModTimeAccuracy = (long)folder.getFileSystem().getLastModTimeAccuracy();
            long lastModifiedTime = folder.getContent().getLastModifiedTime();
            this.assertDelta("set/getLastModified on Folder", yesterday, lastModifiedTime, lastModTimeAccuracy);
        }
    }

    @Test
    public void testSetLastModifiedFile() throws FileSystemException {
        long yesterday = System.currentTimeMillis() - 86400000L;
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            FileObject file = this.getReadFolder().resolveFile("file1.txt");
            file.getContent().setLastModifiedTime(yesterday);
            long lastModTimeAccuracy = (long)file.getFileSystem().getLastModTimeAccuracy();
            long lastModifiedTime = file.getContent().getLastModifiedTime();
            this.assertDelta("set/getLastModified on File", yesterday, lastModifiedTime, lastModTimeAccuracy);
        }
    }
}

