/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.junit.Test;

public class NamingTests
extends AbstractProviderTestCase {
    @Test
    public void testRelativeURI() throws Exception {
        this.getManager().setBaseFile(this.getReadFolder());
        FileObject file = this.getManager().resolveFile(".");
        NamingTests.assertSame((String)"file object", (Object)this.getReadFolder(), (Object)file);
        file = this.getManager().resolveFile("some-child");
        NamingTests.assertSame((String)"file object", (Object)this.getReadFolder(), (Object)file.getParent());
        file = this.getManager().resolveFile("some-folder/some-file");
        NamingTests.assertSame((String)"file object", (Object)this.getReadFolder(), (Object)file.getParent().getParent());
        file = this.getManager().resolveFile("..");
        NamingTests.assertSame((String)"file object", (Object)this.getReadFolder().getParent(), (Object)file);
        this.getManager().setBaseFile((FileObject)null);
    }

    @Test
    public void testRelativeUriEncoding() throws Exception {
        this.getManager().setBaseFile(this.getReadFolder());
        String path = this.getReadFolder().getName().getPath();
        FileObject file = this.getManager().resolveFile("%73%6f%6d%65%20%66%69%6c%65");
        NamingTests.assertEquals((String)(path + "/some file"), (String)file.getName().getPathDecoded());
        file = this.getManager().resolveFile("%2e");
        NamingTests.assertEquals((String)path, (String)file.getName().getPathDecoded());
        file = this.getManager().resolveFile("a%25");
        NamingTests.assertEquals((String)(path + "/a%"), (String)file.getName().getPathDecoded());
        file = this.getManager().resolveFile("dir%2fchild");
        NamingTests.assertEquals((String)(path + "/dir/child"), (String)file.getName().getPathDecoded());
        file = this.getManager().resolveFile("dir%5cchild");
        NamingTests.assertEquals((String)(path + "/dir/child"), (String)file.getName().getPathDecoded());
        try {
            this.getManager().resolveFile("%");
            NamingTests.fail();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        try {
            this.getManager().resolveFile("%5");
            NamingTests.fail();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        try {
            this.getManager().resolveFile("%q");
            NamingTests.fail();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        this.getManager().setBaseFile((FileObject)null);
    }

    @Test
    public void testRootFileName() throws Exception {
        FileName rootName = this.getReadFolder().getFileSystem().getRoot().getName();
        NamingTests.assertEquals((String)"root path", (String)"/", (String)rootName.getPath());
        NamingTests.assertEquals((String)"root base name", (String)"", (String)rootName.getBaseName());
        NamingTests.assertNull((String)"root parent", (Object)rootName.getParent());
    }

    @Test
    public void testChildName() throws Exception {
        FileName baseName = this.getReadFolder().getName();
        String basePath = baseName.getPath();
        FileName name = this.getManager().resolveName(baseName, "some-child", NameScope.CHILD);
        NamingTests.assertTrue((String)"is absolute", (boolean)basePath.startsWith("/"));
        NamingTests.assertEquals((String)"base name", (String)"some-child", (String)name.getBaseName());
        NamingTests.assertEquals((String)"absolute path", (String)(basePath + "/some-child"), (String)name.getPath());
        NamingTests.assertEquals((String)"parent absolute path", (String)basePath, (String)name.getParent().getPath());
        this.assertBadName(name, "a/b", NameScope.CHILD);
        this.checkDescendentNames(name, NameScope.CHILD);
    }

    private void checkDescendentNames(FileName name, NameScope scope) throws Exception {
        NamingTests.assertFalse((boolean)name.getPath().equals("/"));
        NamingTests.assertFalse((boolean)name.getPath().endsWith("/a"));
        NamingTests.assertFalse((boolean)name.getPath().endsWith("/a/b"));
        String path = name.getPath() + "/a";
        this.assertSameName(path, name, path, scope);
        this.assertSameName(path, name, "../" + name.getBaseName() + "/a", scope);
        this.assertBadName(name, "", scope);
        this.assertBadName(name, ".", scope);
        this.assertBadName(name, "./", scope);
        this.assertBadName(name, "..", scope);
        this.assertBadName(name, "../a", scope);
        this.assertBadName(name, "../" + name.getBaseName() + "a", scope);
        this.assertBadName(name, "a/..", scope);
        this.assertBadName(name, "/", scope);
        this.assertBadName(name, "/a", scope);
        this.assertBadName(name, "/a/b", scope);
        this.assertBadName(name, name.getPath(), scope);
        this.assertBadName(name, name.getPath() + "a", scope);
    }

    private void assertSameName(String expectedPath, FileName baseName, String relName, NameScope scope) throws Exception {
        FileName name = this.getManager().resolveName(baseName, relName, scope);
        NamingTests.assertEquals((String)expectedPath, (String)name.getPath());
        String temp = relName.replace('\\', '/');
        name = this.getManager().resolveName(baseName, temp, scope);
        NamingTests.assertEquals((String)expectedPath, (String)name.getPath());
        temp = relName.replace('/', '\\');
        name = this.getManager().resolveName(baseName, temp, scope);
        NamingTests.assertEquals((String)expectedPath, (String)name.getPath());
    }

    private void assertSameName(String expectedPath, FileName baseName, String relName) throws Exception {
        this.assertSameName(expectedPath, baseName, relName, NameScope.FILE_SYSTEM);
    }

    @Test
    public void testNameResolution() throws Exception {
        FileName baseName = this.getReadFolder().getName();
        String parentPath = baseName.getParent().getPath();
        String path = baseName.getPath();
        String childPath = path + "/some-child";
        this.assertSameName(path, baseName, "");
        this.assertSameName(path, baseName, ".");
        this.assertSameName(path, baseName, "./");
        this.assertSameName(path, baseName, ".//");
        this.assertSameName(path, baseName, ".///.///.");
        this.assertSameName(path, baseName, "./\\/.\\//.");
        this.assertSameName(path, baseName, "a/..");
        this.assertSameName(parentPath, baseName, "..");
        this.assertSameName(parentPath, baseName, "../");
        this.assertSameName(parentPath, baseName, "..//./");
        this.assertSameName(parentPath, baseName, "..//.\\");
        this.assertSameName(parentPath, baseName, "a/../..");
        this.assertSameName(childPath, baseName, "some-child");
        this.assertSameName(childPath, baseName, "./some-child");
        this.assertSameName(childPath, baseName, "./some-child/");
        this.assertSameName(childPath, baseName, "./some-child/././././");
        this.assertSameName(childPath, baseName, "a/../some-child");
        this.assertSameName(childPath, baseName, "a/b/../../some-child");
    }

    @Test
    public void testDescendentName() throws Exception {
        FileName baseName = this.getReadFolder().getName();
        String path = baseName.getPath() + "/some-child";
        this.assertSameName(path, baseName, "some-child", NameScope.DESCENDENT);
        path = path + "/grand-child";
        this.assertSameName(path, baseName, "some-child/grand-child", NameScope.DESCENDENT);
        this.assertSameName(path, baseName, "./some-child/grand-child", NameScope.DESCENDENT);
        this.assertSameName(path, baseName, "./nada/../some-child/grand-child", NameScope.DESCENDENT);
        this.assertSameName(path, baseName, "some-child/./grand-child", NameScope.DESCENDENT);
        this.checkDescendentNames(baseName, NameScope.DESCENDENT);
    }

    @Test
    public void testAbsoluteNames() throws Exception {
        FileName name = this.getReadFolder().getName();
        this.checkAbsoluteNames(name);
        name = this.getReadFolder().getFileSystem().getRoot().getName();
        this.checkAbsoluteNames(name);
        name = this.getManager().resolveName(name, "a/b/unknown");
        this.checkAbsoluteNames(name);
    }

    private void checkAbsoluteNames(FileName name) throws Exception {
        this.assertSameName("/", name, "/");
        this.assertSameName("/", name, "//");
        this.assertSameName("/", name, "/.");
        this.assertSameName("/", name, "/some file/..");
        this.assertSameName("/a", name, "/a");
        this.assertSameName("/a", name, "/./a");
        this.assertSameName("/a", name, "/a/.");
        this.assertSameName("/a/b", name, "/a/b");
        this.assertBadName(name, "/..", NameScope.FILE_SYSTEM);
        this.assertBadName(name, "/a/../..", NameScope.FILE_SYSTEM);
    }

    private void assertBadName(FileName name, String relName, NameScope scope) {
        try {
            this.getManager().resolveName(name, relName, scope);
            NamingTests.fail((String)"expected failure");
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    @Test
    public void testAbsoluteNameConvert() throws Exception {
        FileName baseName = this.getReadFolder().getName();
        String path = "/test1/test2";
        FileName name = this.getManager().resolveName(baseName, path);
        NamingTests.assertEquals((String)path, (String)name.getPath());
        this.testRelName(name, "child");
        this.testRelName(name, "child1/child2");
        this.testRelName(name, ".");
        this.testRelName(name, "..");
        this.testRelName(name, "../..");
        this.testRelName(name, "../sibling");
        this.testRelName(name, "../sibling/child");
        this.testRelName(name, "../test2_not");
        this.testRelName(name, "../test2_not/child");
        this.testRelName(name, "../test");
        this.testRelName(name, "../test/child");
        this.testRelName(name, "../../unrelated");
        this.testRelName(name, "../../test");
        this.testRelName(name, "../../test/child");
        path = "/";
        name = this.getManager().resolveName(baseName, path);
        NamingTests.assertEquals((String)path, (String)name.getPath());
        this.testRelName(name, "child");
        this.testRelName(name, "child1/child2");
        this.testRelName(name, ".");
    }

    private void testRelName(FileName baseName, String relPath) throws Exception {
        FileName expectedName = this.getManager().resolveName(baseName, relPath);
        String actualRelPath = baseName.getRelativeName(expectedName);
        NamingTests.assertEquals((String)relPath, (String)actualRelPath);
    }
}

