/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.junit.Test;

public class PathTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.URI};
    }

    @Test
    public void testAbsoluteURI() throws Exception {
        FileObject readFolder = this.getReadFolder();
        String pathStr = readFolder.getPath().toString();
        try (FileObject fileObject = this.getManager().resolveFile(pathStr, readFolder.getFileSystem().getFileSystemOptions());){
            PathTests.assertSame((String)"file object", (Object)readFolder, (Object)fileObject);
        }
        Path rootPath = Paths.get(readFolder.getName().getRootURI(), new String[0]);
        try (FileObject fileObject = this.getManager().resolveFile(rootPath.toString(), readFolder.getFileSystem().getFileSystemOptions());){
            PathTests.assertSame((Object)readFolder.getFileSystem().getRoot(), (Object)fileObject);
            PathTests.assertEquals((Object)rootPath, (Object)Paths.get(fileObject.getName().getRootURI(), new String[0]));
            PathTests.assertEquals((Object)rootPath, (Object)fileObject.getName().getPath());
            PathTests.assertEquals((String)"/", (String)fileObject.getName().getPath());
        }
    }

    @Test
    public void testGetPath() throws Exception {
        try (FileObject fileObject = this.getReadFolder().resolveFile("some-dir/");){
            Path path = fileObject.getPath();
            PathTests.assertEquals((String)Paths.get(fileObject.getName().getURI(), new String[0]).toString(), (String)path.toString());
            PathTests.assertEquals((Object)Paths.get(fileObject.getName().getURI(), new String[0]), (Object)path);
            PathTests.assertEquals((String)fileObject.getPath().toString(), (String)fileObject.getURI().toString());
        }
    }

    @Test
    public void testReservedCharacterSpace() throws FileSystemException {
        String string;
        Path path;
        try (FileObject fileObject = this.getReadFolder().resolveFile("file with spaces.txt");){
            path = fileObject.getPath();
            string = path.toString();
            PathTests.assertTrue((String)string, (boolean)string.contains("file%20with%20spaces.txt"));
        }
        fileObject = this.getReadFolder().resolveFile("file%20with%20spaces.txt");
        var2_2 = null;
        try {
            path = fileObject.getPath();
            string = path.toString();
            PathTests.assertTrue((String)string, (boolean)string.contains("file%20with%20spaces.txt"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (fileObject != null) {
                if (var2_2 != null) {
                    try {
                        fileObject.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    fileObject.close();
                }
            }
        }
    }

    @Test
    public void testURIContentProvider() throws Exception {
        try (FileObject fileObject = this.getReadFolder().resolveFile("file1.txt");){
            PathTests.assertTrue((boolean)fileObject.exists());
            Path path = fileObject.getPath();
            String pathStr = path.toString();
            FileSystemOptions options = this.getReadFolder().getFileSystem().getFileSystemOptions();
            try (FileObject f1 = this.getManager().resolveFile(pathStr, options);
                 FileObject f2 = this.getManager().resolveFile(pathStr, options);){
                PathTests.assertEquals((String)("Two files resolved by URI must be equals on " + pathStr), (Object)f1, (Object)f2);
                PathTests.assertSame((String)("Resolving two times should not produce new filesystem on " + pathStr), (Object)f1.getFileSystem(), (Object)f2.getFileSystem());
            }
        }
    }
}

