/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.test.FileInfo;
import org.apache.commons.vfs2.test.VerifyingFileSelector;
import org.junit.Assert;
import org.junit.Test;

public class ProviderReadTests
extends AbstractProviderTestCase {
    protected FileObject getReadFolderDir1() throws FileSystemException {
        return this.getReadFolder().resolveFile("dir1");
    }

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT};
    }

    @Test
    public void testStructure() throws Exception {
        FileInfo baseInfo = this.buildExpectedStructure();
        this.assertSameStructure(this.getReadFolder(), baseInfo);
    }

    protected void assertSameStructure(FileObject folder, FileInfo expected) throws Exception {
        ArrayList<FileInfo> queueExpected = new ArrayList<FileInfo>();
        queueExpected.add(expected);
        ArrayList<FileObject> queueActual = new ArrayList<FileObject>();
        queueActual.add(folder);
        while (queueActual.size() > 0) {
            FileObject file = (FileObject)queueActual.remove(0);
            FileInfo info = (FileInfo)queueExpected.remove(0);
            ProviderReadTests.assertSame((Object)info.type, (Object)file.getType());
            if (info.type == FileType.FILE) continue;
            FileObject[] children = file.getChildren();
            ProviderReadTests.assertNotNull((Object)children);
            int length = children.length;
            if (info.children.size() != children.length) {
                for (FileObject element : children) {
                    if (element.getName().getBaseName().startsWith(".")) {
                        --length;
                        continue;
                    }
                    System.out.println(element.getName());
                }
            }
            ProviderReadTests.assertEquals((String)("count children of \"" + file.getName() + "\""), (int)info.children.size(), (int)length);
            for (FileObject child : children) {
                String childName = child.getName().getBaseName();
                if (childName.startsWith(".")) continue;
                FileInfo childInfo = info.children.get(childName);
                ProviderReadTests.assertNotNull((Object)childInfo);
                queueExpected.add(childInfo);
                queueActual.add(child);
            }
        }
    }

    @Test
    public void testType() throws Exception {
        FileObject file = this.resolveFile1Txt();
        ProviderReadTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        ProviderReadTests.assertTrue((boolean)file.isFile());
        file = this.getReadFolderDir1();
        ProviderReadTests.assertSame((Object)FileType.FOLDER, (Object)file.getType());
        ProviderReadTests.assertTrue((boolean)file.isFolder());
        file = this.getReadFolder().resolveFile("unknown-child");
        ProviderReadTests.assertSame((Object)FileType.IMAGINARY, (Object)file.getType());
    }

    @Test
    public void testRoot() throws FileSystemException {
        if (!this.getProviderConfig().isFileSystemRootAccessible()) {
            return;
        }
        FileSystem fs = this.getFileSystem();
        String uri = fs.getRootURI();
        FileObject file = this.getManager().resolveFile(uri, fs.getFileSystemOptions());
        file.getChildren();
    }

    @Test
    public void testSort() throws FileSystemException {
        FileInfo fileInfo = this.buildExpectedStructure();
        VerifyingFileSelector selector = new VerifyingFileSelector(fileInfo);
        Object[] actualFiles = this.getReadFolder().findFiles((FileSelector)selector);
        Arrays.sort(actualFiles);
        Object prevActualFile = actualFiles[0];
        for (Object actualFile : actualFiles) {
            ProviderReadTests.assertTrue((prevActualFile.toString().compareTo(actualFile.toString()) <= 0 ? 1 : 0) != 0);
            prevActualFile = actualFile;
        }
        List<FileObject> expectedFiles = selector.finish();
        Collections.sort(expectedFiles);
        ProviderReadTests.assertEquals((int)expectedFiles.size(), (int)actualFiles.length);
        int count = expectedFiles.size();
        for (int i = 0; i < count; ++i) {
            FileObject expected = expectedFiles.get(i);
            Object actual = actualFiles[i];
            ProviderReadTests.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testFolderContent() throws Exception {
        if (this.getFileSystem().hasCapability(Capability.DIRECTORY_READ_CONTENT)) {
            return;
        }
        FileObject folder = this.getReadFolderDir1();
        try {
            folder.getContent().getInputStream();
            ProviderReadTests.fail();
        }
        catch (FileSystemException e) {
            ProviderReadTests.assertSameMessage("vfs.provider/read-not-file.error", folder, (Throwable)e);
        }
    }

    @Test
    public void testFolderIsHidden() throws Exception {
        FileObject folder = this.getReadFolderDir1();
        Assert.assertFalse((boolean)folder.isHidden());
    }

    @Test
    public void testFolderIsSymbolicLink() throws Exception {
        FileObject folder = this.getReadFolderDir1();
        Assert.assertFalse((boolean)folder.isSymbolicLink());
    }

    @Test
    public void testFolderIsReadable() throws Exception {
        FileObject folder = this.getReadFolderDir1();
        Assert.assertTrue((boolean)folder.isReadable());
    }

    @Test
    public void testGetContent() throws Exception {
        FileObject file = this.resolveFile1Txt();
        ProviderReadTests.assertTrue((boolean)file.exists());
        FileContent content = file.getContent();
        ProviderReadTests.assertNotNull((Object)content);
    }

    @Test
    public void testGetContentInfo() throws Exception {
        FileObject file = this.resolveFile1Txt();
        ProviderReadTests.assertTrue((boolean)file.exists());
        FileContent content = file.getContent();
        ProviderReadTests.assertNotNull((Object)content);
        FileContentInfo contentInfo = content.getContentInfo();
        ProviderReadTests.assertNotNull((Object)contentInfo);
    }

    private FileObject resolveFile1Txt() throws FileSystemException {
        return this.getReadFolder().resolveFile("file1.txt");
    }

    @Test
    public void testReadEmptyMultipleEOF() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("empty.txt");
        ProviderReadTests.assertTrue((boolean)file.exists());
        try (InputStream instr = file.getContent().getInputStream();){
            ProviderReadTests.assertEquals((String)"read() from empty file should return EOF", (int)-1, (int)instr.read());
            for (int i = 0; i < 5; ++i) {
                ProviderReadTests.assertEquals((String)"multiple read() at EOF should return EOF", (int)-1, (int)instr.read());
            }
        }
    }

    @Test
    public void testReadFileEOFMultiple() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ProviderReadTests.assertTrue((boolean)file.exists());
        ProviderReadTests.assertEquals((String)"Expecting 20 bytes test-data file1.txt", (long)20L, (long)file.getContent().getSize());
        try (InputStream instr = file.getContent().getInputStream();){
            byte[] buf = new byte[25];
            ProviderReadTests.assertEquals((int)20, (int)instr.read(buf));
            for (int i = 0; i < 5; ++i) {
                ProviderReadTests.assertEquals((String)"multiple read(byte[]) at EOF should return EOF", (int)-1, (int)instr.read(buf));
            }
        }
    }

    @Test
    public void testConcurrentReadFolder() throws Exception {
        FileObject file = this.resolveFile1Txt();
        ProviderReadTests.assertTrue((boolean)file.exists());
        FileObject folder = this.getReadFolderDir1();
        ProviderReadTests.assertTrue((boolean)folder.exists());
        try (InputStream instr = file.getContent().getInputStream();){
            folder.exists();
            folder.getType();
            folder.getChildren();
        }
    }

    @Test
    public void testFindFiles() throws Exception {
        FileInfo fileInfo = this.buildExpectedStructure();
        VerifyingFileSelector selector = new VerifyingFileSelector(fileInfo);
        FileObject[] actualFiles = this.getReadFolder().findFiles((FileSelector)selector);
        List<FileObject> expectedFiles = selector.finish();
        ProviderReadTests.assertEquals((int)expectedFiles.size(), (int)actualFiles.length);
        int count = expectedFiles.size();
        for (int i = 0; i < count; ++i) {
            FileObject expected = expectedFiles.get(i);
            FileObject actual = actualFiles[i];
            ProviderReadTests.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDotJarFolderName() throws Exception {
        FileObject folder = this.getReadFolderDir1().resolveFile("subdir4.jar");
        Assert.assertTrue((boolean)folder.exists());
        FileObject file = folder.resolveFile("file1.txt");
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testDotJarFolderNameLayer() throws Exception {
        FileObject folder = this.getReadFolderDir1().resolveFile("subdir4.jar");
        Assert.assertTrue((String)"subdir4.jar/ must exist as folder, check test setup.", (boolean)folder.isFolder());
        Assert.assertFalse((String)"subdir4.jar/ must not be layerable", (boolean)this.getManager().canCreateFileSystem(folder));
        try {
            FileObject ignored = this.getManager().createFileSystem(folder);
            ProviderReadTests.fail((String)("Should not be able to create a layered filesystem on a directory. " + ignored));
        }
        catch (FileSystemException e) {
            ProviderReadTests.assertSame((String)("Creation of layered filesystem should fail" + (Object)((Object)e)), (Object)"vfs.impl/no-provider-for-file.error", (Object)e.getCode());
        }
    }
}

