/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.junit.Test;

public class UrlStructureTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.URI};
    }

    @Test
    public void testFolderURL() throws Exception {
        FileObject folder = this.getReadFolder().resolveFile("dir1");
        if (folder.getFileSystem().hasCapability(Capability.DIRECTORY_READ_CONTENT)) {
            return;
        }
        UrlStructureTests.assertTrue((boolean)folder.exists());
        try (InputStream inputStream = folder.getURL().openConnection().getInputStream();){
            UrlStructureTests.fail();
        }
        catch (IOException e) {
            UrlStructureTests.assertSameMessage("vfs.provider/read-not-file.error", folder, (Throwable)e);
        }
    }
}

