/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.util.Messages;

public abstract class AbstractVfsTestCase
extends TestCase {
    private static File baseDir;
    private static final Pattern URL_PATTERN;
    private static final Pattern PASSWORD_PATTERN;

    public static void assertSameMessage(String code, Object param, Throwable throwable) {
        AbstractVfsTestCase.assertSameMessage(code, new Object[]{param}, throwable);
    }

    private static void assertSameMessage(String code, Object[] params, Throwable throwable) {
        Object[] parmArray = params;
        if (throwable instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)throwable;
            AbstractVfsTestCase.assertEquals((String)code, (String)fse.getCode());
            AbstractVfsTestCase.assertEquals((int)params.length, (int)fse.getInfo().length);
            parmArray = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                String value = String.valueOf(params[i]);
                Matcher urlMatcher = URL_PATTERN.matcher(value);
                if (urlMatcher.find()) {
                    Matcher pwdMatcher = PASSWORD_PATTERN.matcher(value);
                    value = pwdMatcher.replaceFirst(":***@");
                }
                AbstractVfsTestCase.assertEquals((String)value, (String)fse.getInfo()[i]);
                parmArray[i] = value;
            }
        }
        String message = Messages.getString((String)code, (Object[])parmArray);
        AbstractVfsTestCase.assertEquals((String)message, (String)throwable.getMessage());
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static String getResourceTestDirectory() {
        return System.getProperty("test.basedir.res", "test-data");
    }

    public static String getTestDirectory() {
        return System.getProperty("test.basedir", "target/test-classes/test-data");
    }

    public static File getTestDirectory(String name) {
        File file = new File(AbstractVfsTestCase.getTestDirectoryFile(), name);
        file = AbstractVfsTestCase.getCanonicalFile(file);
        AbstractVfsTestCase.assertTrue((String)("Test directory \"" + file + "\" does not exist or is not a directory."), (file.isDirectory() || file.mkdirs() ? 1 : 0) != 0);
        return file;
    }

    public static File getTestDirectoryFile() {
        if (baseDir == null) {
            String baseDirProp = AbstractVfsTestCase.getTestDirectory();
            if (baseDirProp.startsWith("file://")) {
                try {
                    baseDir = AbstractVfsTestCase.getCanonicalFile(new File(new URI(baseDirProp)));
                }
                catch (URISyntaxException e) {
                    baseDir = AbstractVfsTestCase.getCanonicalFile(new File(baseDirProp));
                }
            } else {
                baseDir = AbstractVfsTestCase.getCanonicalFile(new File(baseDirProp));
            }
        }
        return baseDir;
    }

    public static File getTestResource(String name) {
        return AbstractVfsTestCase.getTestResource(name, true);
    }

    public static File getTestResource(String name, boolean mustExist) {
        File file = new File(AbstractVfsTestCase.getTestDirectoryFile(), name);
        file = AbstractVfsTestCase.getCanonicalFile(file);
        if (mustExist) {
            AbstractVfsTestCase.assertTrue((String)("Test file \"" + file + "\" does not exist."), (boolean)file.exists());
        } else {
            AbstractVfsTestCase.assertFalse((String)("Test file \"" + file + "\" should not exist."), (boolean)file.exists());
        }
        return file;
    }

    static {
        URL_PATTERN = Pattern.compile("[a-z]+://.*");
        PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    }
}

