/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.junit.Assert;
import org.junit.Test;

public class LastModifiedTests
extends AbstractProviderTestCase {
    protected static final Duration ONE_DAY = Duration.ofDays(1L);

    protected void assertDeltaMillis(String message, long expected, long actual, long delta) {
        if (expected == actual) {
            return;
        }
        long actualDelta = Math.abs(expected - actual);
        if (actualDelta > Math.max(delta, 1000L)) {
            Assert.fail((String)String.format("%s expected=%,d (%s), actual=%,d (%s), expected delta=%,d, actual delta=%,d", message, expected, new Date(expected).toString(), actual, new Date(actual).toString(), delta, actualDelta));
        }
    }

    protected void assertEqualMillis(String message, long expected, long actual) {
        if (expected != actual) {
            long delta = Math.abs(expected - actual);
            Assert.fail((String)String.format("%s expected=%,d (%s), actual=%,d (%s), delta=%,d", message, expected, new Date(expected).toString(), actual, new Date(actual).toString(), delta));
        }
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.GET_LAST_MODIFIED};
    }

    @Test
    public void testGetAccurary() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        long lastModTimeAccuracyMillis = (long)file.getFileSystem().getLastModTimeAccuracy();
        LastModifiedTests.assertTrue((String)"Accuracy must be positive", (lastModTimeAccuracyMillis >= 0L ? 1 : 0) != 0);
        LastModifiedTests.assertTrue((String)"Accuracy must be < 2m", (lastModTimeAccuracyMillis < Duration.ofMinutes(2L).toMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetLastModifiedFolder() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("dir1");
        Assert.assertNotEquals((long)0L, (long)file.getContent().getLastModifiedTime());
    }

    @Test
    public void testGetLastModifiedFile() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        Assert.assertNotEquals((long)0L, (long)file.getContent().getLastModifiedTime());
    }

    @Test
    public void testSetLastModifiedFolder() throws FileSystemException {
        long yesterdayMillis = Instant.now().minus(ONE_DAY).toEpochMilli();
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) {
            FileObject folder = this.getReadFolder().resolveFile("dir1");
            folder.getContent().setLastModifiedTime(yesterdayMillis);
            long lastModTimeAccuracyMillis = (long)folder.getFileSystem().getLastModTimeAccuracy();
            long lastModifiedTime = folder.getContent().getLastModifiedTime();
            this.assertDeltaMillis("set/getLastModified on Folder", yesterdayMillis, lastModifiedTime, lastModTimeAccuracyMillis);
        }
    }

    @Test
    public void testSetLastModifiedFile() throws FileSystemException {
        long yesterdayMillis = Instant.now().minus(ONE_DAY).toEpochMilli();
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            FileObject file = this.getReadFolder().resolveFile("file1.txt");
            file.getContent().setLastModifiedTime(yesterdayMillis);
            long lastModTimeAccuracyMillis = (long)file.getFileSystem().getLastModTimeAccuracy();
            long lastModifiedTime = file.getContent().getLastModifiedTime();
            this.assertDeltaMillis("set/getLastModified on File", yesterdayMillis, lastModifiedTime, lastModTimeAccuracyMillis);
        }
    }
}

