/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class PermissionsTests
extends AbstractProviderTestCase {
    public static final String FILENAME = "permission.txt";

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    @Test
    public void testExecutable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assert.assertTrue((String)("File expected to be executable: " + file), (boolean)file.isExecutable());
        } else {
            Assert.assertTrue((String)("Setting executable permission failed: " + file), (boolean)file.setExecutable(true, true));
            Assert.assertTrue((String)("File expected to be executable: " + file), (boolean)file.isExecutable());
            Assert.assertTrue((String)("Setting executable permission failed: " + file), (boolean)file.setExecutable(true, false));
            Assert.assertTrue((String)("File expected to be executable: " + file), (boolean)file.isExecutable());
            Assert.assertTrue((String)("Setting executable permission failed: " + file), (boolean)file.setExecutable(false, true));
            Assert.assertFalse((String)("File expected to be not executable: " + file), (boolean)file.isExecutable());
        }
    }

    @Test
    public void testWriteable() throws Exception {
        FileObject file = this.createTestFile();
        Assert.assertTrue((String)("Setting write permission failed: " + file), (boolean)file.setWritable(true, true));
        Assert.assertTrue((String)("File expected to be writable: " + file), (boolean)file.isWriteable());
        Assert.assertTrue((String)("Setting write permission failed: " + file), (boolean)file.setWritable(true, false));
        Assert.assertTrue((String)("File expected to be writable: " + file), (boolean)file.isWriteable());
        Assert.assertTrue((String)("Setting write permission failed: " + file), (boolean)file.setWritable(false, true));
        Assert.assertFalse((String)("File expected to be not writable: " + file), (boolean)file.isWriteable());
    }

    @Test
    public void testReadable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assert.assertTrue((String)("File expected to be readable: " + file), (boolean)file.isReadable());
        } else {
            Assert.assertTrue((String)("Setting read permission failed: " + file), (boolean)file.setReadable(true, true));
            Assert.assertTrue((String)("File expected to be readable: " + file), (boolean)file.isReadable());
            Assert.assertTrue((String)("Setting read permission failed: " + file), (boolean)file.setReadable(true, false));
            Assert.assertTrue((String)("File expected to be readable: " + file), (boolean)file.isReadable());
            Assert.assertTrue((String)("Setting read permission failed: " + file), (boolean)file.setReadable(false, true));
            Assert.assertFalse((String)("File expected to be not readable: " + file), (boolean)file.isReadable());
        }
    }

    protected void tearDown() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        file.setWritable(true, true);
        file.delete();
        super.tearDown();
    }

    private FileObject createTestFile() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        PermissionsTests.assertNotNull((Object)scratchFolder);
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        PermissionsTests.assertFalse((boolean)file.exists());
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        return file;
    }

    private boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS && this.getFileSystem() instanceof LocalFileSystem;
    }
}

