/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.commons.vfs2.Selectors;
import org.junit.Test;

public class ProviderDeleteTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        FileObject dir1 = scratchFolder.resolveFile("dir1");
        dir1.createFolder();
        FileObject dir1file1 = dir1.resolveFile("a.txt");
        dir1file1.createFile();
        FileObject dir2 = scratchFolder.resolveFile("dir2");
        dir2.createFolder();
        FileObject dir2file1 = dir2.resolveFile("b.txt");
        dir2file1.createFile();
        return scratchFolder;
    }

    @Test
    public void testDeleteFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)4, (int)scratchFolder.delete(Selectors.EXCLUDE_SELF));
    }

    @Test
    public void testDeleteFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("dir1/a.txt");
        ProviderDeleteTests.assertTrue((boolean)file.delete());
    }

    @Test
    public void testDeleteNonExistantFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("dir1/aa.txt");
        ProviderDeleteTests.assertFalse((boolean)file.delete());
    }

    @Test
    public void testDeleteAllFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)2, (int)scratchFolder.delete((FileSelector)new FileTypeSelector(FileType.FILE)));
    }

    @Test
    public void testDeleteOneFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)1, (int)scratchFolder.delete((FileSelector)new FileNameSelector("a.txt")));
    }

    private class FileNameSelector
    implements FileSelector {
        final String basename;

        private FileNameSelector(String basename) {
            this.basename = basename;
        }

        public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
            return this.basename.equals(fileInfo.getFile().getName().getBaseName());
        }

        public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
            return true;
        }
    }
}

