/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.junit.Test;

public class ProviderRandomReadWriteTests
extends AbstractProviderTestCase {
    private static final String TEST_DATA = "This is a test file.";

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.GET_TYPE, Capability.CREATE, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Test
    public void testRandomWrite() throws Exception {
        try (FileObject file = this.createScratchFolder().resolveFile("random_write.txt");){
            file.createFile();
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READWRITE);
            ra.writeByte((int)TEST_DATA.charAt(0));
            ra.seek(3L);
            ra.writeByte((int)TEST_DATA.charAt(3));
            ra.writeByte((int)TEST_DATA.charAt(4));
            ra.seek(3L);
            ra.writeByte((int)TEST_DATA.charAt(7));
            ra.writeByte((int)TEST_DATA.charAt(8));
            ra.seek(10L);
            ra.writeByte((int)TEST_DATA.charAt(10));
            ra.writeByte((int)TEST_DATA.charAt(11));
            ra.seek(0L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)TEST_DATA.charAt(0));
            ra.seek(3L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)TEST_DATA.charAt(7));
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)TEST_DATA.charAt(8));
            ra.seek(10L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)TEST_DATA.charAt(10));
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)TEST_DATA.charAt(11));
        }
    }
}

