/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.junit.Test;

public class ProviderWriteAppendTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Test
    public void testAppendContent() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteAppendTests.assertFalse((boolean)file.exists());
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        String contentAppend = "Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        var6_6 = null;
        try (OutputStream os2 = file.getContent().getOutputStream(true);){
            os2.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileCopy = scratchFolder.resolveFile("file1copy.txt");
        ProviderWriteAppendTests.assertFalse((boolean)fileCopy.exists());
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
        ProviderWriteAppendTests.assertTrue((boolean)fileCopy.exists());
        ProviderWriteAppendTests.assertTrue((boolean)fileCopy.delete());
    }
}

