/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.junit.Test;

public abstract class AbstractFilesCacheTestsBase
extends AbstractProviderTestCase {
    @Test
    public void testClearFiles() throws Exception {
        FilesCache cache = this.getManager().getFilesCache();
        FileObject fo1 = this.getWriteFolder().resolveFile("dir1");
        cache.clear(fo1.getFileSystem());
        cache.clear(fo1.getFileSystem());
        FileObject fo2 = this.getWriteFolder().resolveFile("dir1");
        AbstractFilesCacheTestsBase.assertNotSame((String)"Objects after cache clear should be different", (Object)fo1, (Object)fo2);
    }

    @Test
    public void testBasicCacheOps() throws Exception {
        FilesCache cache = this.getManager().getFilesCache();
        FileObject fo = this.getWriteFolder().resolveFile("dir1");
        FileName fn = fo.getName();
        FileSystem fs = fo.getFileSystem();
        cache.clear(fs);
        AbstractFilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        cache.putFile(fo);
        AbstractFilesCacheTestsBase.assertSame((Object)fo, (Object)cache.getFile(fs, fn));
        AbstractFilesCacheTestsBase.assertFalse((boolean)cache.putFileIfAbsent(fo));
        cache.clear(fs);
        AbstractFilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        AbstractFilesCacheTestsBase.assertTrue((boolean)cache.putFileIfAbsent(fo));
        cache.removeFile(fs, fn);
        AbstractFilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        AbstractFilesCacheTestsBase.assertTrue((boolean)cache.putFileIfAbsent(fo));
    }

    protected int getFileHashCode() throws FileSystemException {
        FileObject fo = this.getWriteFolder().resolveFile("file2");
        if (!fo.exists()) {
            fo.createFile();
        }
        return fo.hashCode();
    }
}

