/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.AndFileFilter;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.junit.Assert;
import org.junit.Test;

public class AndFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAndFileFilterFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        AndFileFilter testee = new AndFileFilter(new FileFilter[]{filter1, filter2, filter3});
        AndFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testAndFileFilterList() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        ArrayList<DummyFilter> list = new ArrayList<DummyFilter>();
        list.add(filter1);
        list.add(filter2);
        list.add(filter3);
        AndFileFilter testee = new AndFileFilter(list);
        AndFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testAddFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        AndFileFilter testee = new AndFileFilter();
        testee.addFileFilter((FileFilter)filter1);
        testee.addFileFilter((FileFilter)filter2);
        testee.addFileFilter((FileFilter)filter3);
        AndFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testRemoveFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        AndFileFilter testee = new AndFileFilter(new FileFilter[]{filter1, filter2, filter3});
        testee.removeFileFilter((FileFilter)filter2);
        AndFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter3);
    }

    @Test
    public void testSetFileFilters() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        ArrayList<DummyFilter> list = new ArrayList<DummyFilter>();
        list.add(filter1);
        list.add(filter2);
        list.add(filter3);
        AndFileFilter testee = new AndFileFilter();
        testee.setFileFilters(list);
        AndFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testAccept() throws FileSystemException {
        FileSelectInfo any = AndFileFilterTest.createFileSelectInfo(new File("anyfile"));
        Assert.assertFalse((boolean)new AndFileFilter().accept(any));
        Assert.assertTrue((boolean)new AndFileFilter(new FileFilter[]{new True()}).accept(any));
        Assert.assertTrue((boolean)new AndFileFilter(new FileFilter[]{new True(), new True()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False(), new False()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False(), new True()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new True(), new False()}).accept(any));
    }

    @Test
    public void testAcceptChecked() throws FileSystemException {
        FileSelectInfo any = AndFileFilterTest.createFileSelectInfo(new File("anyfile"));
        Assert.assertFalse((boolean)new AndFileFilter().accept(any));
        Assert.assertTrue((boolean)new AndFileFilter(new FileFilter[]{new True()}).accept(any));
        Assert.assertTrue((boolean)new AndFileFilter(new FileFilter[]{new True(), new True()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False(), new False()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new False(), new True()}).accept(any));
        Assert.assertFalse((boolean)new AndFileFilter(new FileFilter[]{new True(), new False()}).accept(any));
    }

    private static class False
    implements FileFilter {
        private False() {
        }

        public boolean accept(FileSelectInfo fileSelectInfo) {
            return false;
        }
    }

    private static class True
    implements FileFilter {
        private True() {
        }

        public boolean accept(FileSelectInfo fileSelectInfo) {
            return true;
        }
    }

    private static class DummyFilter
    implements FileFilter {
        private DummyFilter() {
        }

        public boolean accept(FileSelectInfo fileSelectInfo) {
            return false;
        }
    }
}

