/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProviderTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HdfsFileProviderTestCase
extends AbstractProviderTestConfig {
    private static final int PORT = 8720;
    private static final String HDFS_URI = "hdfs://localhost:8720";
    private static FileSystem hdfs;
    private static Configuration conf;
    private static MiniDFSCluster cluster;

    public static Test suite() throws Exception {
        return new HdfsProviderTestSuite(new HdfsFileProviderTestCase(), false);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = "hdfs://localhost:8720/test-data";
        return manager.resolveFile("hdfs://localhost:8720/test-data");
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("hdfs", (FileProvider)new HdfsFileProvider());
    }

    public static class HdfsProviderTestSuite
    extends ProviderTestSuite {
        public HdfsProviderTestSuite(ProviderTestConfig providerConfig, boolean addEmptyDir) throws Exception {
            super(providerConfig, addEmptyDir);
        }

        private void copyTestResources(File directory, Path parent) throws Exception {
            for (File file : directory.listFiles()) {
                if (file.isFile()) {
                    Path src = new Path(file.getAbsolutePath());
                    Path dst = new Path(parent, file.getName());
                    hdfs.copyFromLocalFile(src, dst);
                    continue;
                }
                if (!file.isDirectory()) continue;
                Path dir = new Path(parent, file.getName());
                if (hdfs.mkdirs(dir)) {
                    this.copyTestResources(file, dir);
                    continue;
                }
                HdfsProviderTestSuite.fail((String)("Unable to make directory: " + dir));
            }
        }

        @Override
        protected void setUp() throws Exception {
            Logger.getRootLogger().setLevel(Level.OFF);
            File data = new File("target/test/hdfstestcasedata").getAbsoluteFile();
            data.mkdirs();
            System.setProperty("test.build.data", data.toString());
            FileUtils.cleanDirectory((File)data);
            conf = new Configuration();
            conf.set("fs.defaultFS", HdfsFileProviderTestCase.HDFS_URI);
            conf.set("hadoop.security.token.service.use_ip", "true");
            conf.setLong("dfs.blocksize", 0x100000L);
            HdfsFileProviderTest.setUmask(conf);
            try {
                cluster = new MiniDFSCluster(8720, conf, 1, true, true, true, null, null, null, null);
                cluster.waitActive();
            }
            catch (IOException e) {
                throw new RuntimeException("Error setting up mini cluster", e);
            }
            hdfs = (FileSystem)cluster.getFileSystem();
            Path base = new Path("/test-data");
            HdfsProviderTestSuite.assertTrue((String)"Unable to create base directory", (boolean)hdfs.mkdirs(base));
            File testDir = AbstractVfsTestCase.getTestDirectoryFile();
            this.copyTestResources(testDir, base);
            super.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            super.tearDown();
            if (null != hdfs) {
                hdfs.close();
            }
        }

        static {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        }
    }
}

