/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.junit.Assert;
import org.junit.Test;

public class Http4GetContentInfoTest
extends TestCase {
    FileSystemOptions getOptionsWithProxy() throws MalformedURLException {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUrl = System.getenv("https_proxy");
        if (proxyUrl != null) {
            URL url = new URL(proxyUrl);
            proxyHost = url.getHost();
            proxyPort = url.getPort();
        }
        if (proxyHost == null || proxyPort == -1) {
            return null;
        }
        Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = new FileSystemOptions();
        builder.setProxyHost(opts, proxyHost);
        builder.setProxyPort(opts, proxyPort);
        builder.setProxyScheme(opts, "http");
        return opts;
    }

    private FileSystemOptions getOptionsWithProxyAuthentication() throws MalformedURLException {
        String proxyHost = null;
        int proxyPort = -1;
        String[] user = null;
        String proxyUrl = System.getenv("https_proxy");
        if (proxyUrl != null) {
            URL url = new URL(proxyUrl);
            proxyHost = url.getHost();
            proxyPort = url.getPort();
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                user = userInfo.split(":");
            }
        }
        if (proxyHost == null || proxyPort == -1) {
            return null;
        }
        Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = new FileSystemOptions();
        builder.setProxyHost(opts, proxyHost);
        builder.setProxyPort(opts, proxyPort);
        if (user != null) {
            builder.setProxyAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator(null, user[0], user[1]));
        }
        return opts;
    }

    @Test
    public void testGetContentInfo() throws FileSystemException, MalformedURLException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http4://www.apache.org/licenses/LICENSE-2.0.txt";
        try (FileObject fo = fsManager.resolveFile("http4://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithProxy());
             FileContent content = fo.getContent();){
            Assert.assertNotNull((Object)content);
            content.getContentInfo();
        }
    }

    @Test
    public void testGetContentWithProxyAuthInfo() throws FileSystemException, MalformedURLException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http4://www.apache.org/licenses/LICENSE-2.0.txt";
        try (FileObject fo = fsManager.resolveFile("http4://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithProxyAuthentication());
             FileContent content = fo.getContent();){
            Assert.assertNotNull((Object)content);
            content.getContentInfo();
        }
    }
}

