/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.File;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http5.Http5FileProvider;
import org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import org.apache.commons.vfs2.util.NHttpFileServer;
import org.junit.Assert;

public class Http5ProviderTestCase
extends AbstractProviderTestConfig {
    private static NHttpFileServer Server;
    private static int SocketPort;
    private static final String TEST_URI = "test.http.uri";
    private static String ConnectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        Server = NHttpFileServer.start(0, new File(Http5ProviderTestCase.getTestDirectory()), 5000L);
        SocketPort = Server.getPort();
        ConnectionUri = "http5://localhost:" + SocketPort;
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new Http5ProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(Http5ProviderTestCase.class);
            }

            @Override
            protected void setUp() throws Exception {
                if (Http5ProviderTestCase.getSystemTestUriOverride() == null) {
                    Http5ProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                Http5ProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() {
        if (Server != null) {
            Server.shutdown(5000L, TimeUnit.SECONDS);
        }
    }

    private void checkReadTestsFolder(FileObject file) throws FileSystemException {
        Assert.assertNotNull((Object)file.getChildren());
        Assert.assertTrue((file.getChildren().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = Http5ProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        return manager.resolveFile(uri);
    }

    public void ignoreTestHttp405() throws FileSystemException {
        FileObject fileObject = VFS.getManager().resolveFile("http5://www.w3schools.com/webservices/tempconvert.asmx?action=WSDL");
        assert (!fileObject.getContent().isEmpty());
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        if (!manager.hasProvider("http5")) {
            manager.addProvider("http5", (FileProvider)new Http5FileProvider());
        }
    }

    public void testHttpTimeoutConfig() {
        FileSystemOptions opts = new FileSystemOptions();
        Http5FileSystemConfigBuilder builder = Http5FileSystemConfigBuilder.getInstance();
        Http5ProviderTestCase.assertEquals((int)0, (int)builder.getConnectionTimeout(opts));
        Http5ProviderTestCase.assertEquals((Object)Duration.ZERO, (Object)builder.getConnectionTimeoutDuration(opts));
        Http5ProviderTestCase.assertEquals((int)0, (int)builder.getSoTimeout(opts));
        Http5ProviderTestCase.assertEquals((Object)Duration.ZERO, (Object)builder.getSoTimeoutDuration(opts));
        Http5ProviderTestCase.assertEquals((String)"Jakarta-Commons-VFS", (String)builder.getUserAgent(opts));
        builder.setConnectionTimeout(opts, 60000);
        builder.setSoTimeout(opts, 60000);
        builder.setUserAgent(opts, "foo/bar");
        Http5ProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(opts));
        Http5ProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(opts));
        Http5ProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(opts));
        builder.setConnectionTimeout(opts, Duration.ofMinutes(1L));
        builder.setSoTimeout(opts, Duration.ofMinutes(1L));
        builder.setUserAgent(opts, "foo/bar");
        Http5ProviderTestCase.assertEquals((long)60000L, (long)builder.getConnectionTimeoutDuration(opts).toMillis());
        Http5ProviderTestCase.assertEquals((long)60000L, (long)builder.getSoTimeoutDuration(opts).toMillis());
        Http5ProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(opts));
    }

    private void testResloveFolderSlash(String uri, boolean followRedirect) throws FileSystemException {
        VFS.getManager().getFilesCache().close();
        FileSystemOptions opts = new FileSystemOptions();
        Http5FileSystemConfigBuilder.getInstance().setFollowRedirect(opts, followRedirect);
        FileObject file = VFS.getManager().resolveFile(uri, opts);
        try {
            this.checkReadTestsFolder(file);
        }
        catch (FileNotFolderException fileNotFolderException) {
            // empty catch block
        }
    }

    public void testResloveFolderSlashNoRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", false);
    }

    public void testResloveFolderSlashNoRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", true);
    }

    public void testResloveFolderSlashYesRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", false);
    }

    public void testResloveFolderSlashYesRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", true);
    }
}

