/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;

public class NestedTbz2TestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedTbz2TestCase(), true);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("tbz2", (FileProvider)new TarFileProvider());
        manager.addExtensionMap("tbz2", "tbz2");
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String tarFilePath = AbstractVfsTestCase.getTestResource("nested.tbz2").getAbsolutePath();
        String uri = "tbz2:file:" + tarFilePath + "!/test.tbz2";
        FileObject tarFile = manager.resolveFile(uri);
        FileObject nestedFS = manager.createFileSystem(tarFile);
        return nestedFS.resolveFile("/");
    }
}

