/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.impl.nio.bootstrap.HttpServer;
import org.apache.http.impl.nio.bootstrap.ServerBootstrap;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.entity.NFileEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.ssl.SSLContexts;

public class NHttpFileServer {
    public static boolean DEBUG;
    private final File docRoot;
    private final int port;
    private HttpServer server;

    private static void debug(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, InterruptedException {
        if (args.length < 1) {
            System.err.println("Please specify document root directory");
            System.exit(1);
        }
        File docRoot = new File(args[0]);
        int port = 8080;
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        new NHttpFileServer(port, docRoot).start().awaitTermination();
    }

    public static NHttpFileServer start(int port, File docRoot, long waitMillis) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, InterruptedException {
        return new NHttpFileServer(port, docRoot).start();
    }

    private NHttpFileServer(int port, File docRoot) {
        this.port = port;
        this.docRoot = docRoot;
    }

    private void awaitTermination() throws InterruptedException {
        this.server.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NHttpFileServer.this.server.shutdown(5L, TimeUnit.SECONDS);
            }
        });
    }

    public int getPort() {
        if (this.server == null) {
            return this.port;
        }
        return ((InetSocketAddress)this.server.getEndpoint().getAddress()).getPort();
    }

    public void shutdown(long gracePeriod, TimeUnit timeUnit) {
        if (this.server != null) {
            this.server.shutdown(gracePeriod, timeUnit);
        }
    }

    private NHttpFileServer start() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, InterruptedException {
        SSLContext sslContext = null;
        if (this.port == 8443) {
            URL url = NHttpFileServer.class.getResource("/test.keystore");
            if (url == null) {
                NHttpFileServer.debug("Keystore not found");
                System.exit(1);
            }
            NHttpFileServer.debug("Loading keystore " + url);
            sslContext = SSLContexts.custom().loadKeyMaterial(url, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        }
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15000).setTcpNoDelay(true).build();
        this.server = ServerBootstrap.bootstrap().setListenerPort(this.port).setServerInfo("Test/1.1").setIOReactorConfig(config).setSslContext(sslContext).setExceptionLogger(ExceptionLogger.STD_ERR).registerHandler("*", (HttpAsyncRequestHandler)new HttpFileHandler(this.docRoot)).create();
        this.server.start();
        NHttpFileServer.debug("Serving " + this.docRoot + " on " + this.server.getEndpoint().getAddress() + (sslContext == null ? "" : " with " + sslContext.getProvider() + " " + sslContext.getProtocol()));
        this.server.getEndpoint().waitFor();
        return this;
    }

    static class HttpFileHandler
    implements HttpAsyncRequestHandler<HttpRequest> {
        private final File docRoot;

        public HttpFileHandler(File docRoot) {
            this.docRoot = docRoot;
        }

        public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
            HttpResponse response = httpexchange.getResponse();
            this.handleInternal(request, response, context);
            httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(response));
        }

        private void handleInternal(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            String target = request.getRequestLine().getUri();
            File file = new File(this.docRoot, URLDecoder.decode(target, "UTF-8"));
            String mimeType = "text/html";
            if (!file.exists()) {
                response.setStatusCode(404);
                NStringEntity entity = new NStringEntity("<html><body><h1>File " + file.getPath() + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)entity);
                NHttpFileServer.debug("File " + file.getPath() + " not found");
            } else if (!file.canRead()) {
                response.setStatusCode(403);
                NStringEntity entity = new NStringEntity("<html><body><h1>Access denied</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)entity);
                NHttpFileServer.debug("Cannot read file " + file.getPath());
            } else {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                HttpConnection conn = coreContext.getConnection(HttpConnection.class);
                response.setStatusCode(200);
                NStringEntity body = file.isDirectory() ? new NStringEntity(file.toString(), ContentType.create((String)"text/html")) : new NFileEntity(file, ContentType.create((String)"text/html"));
                response.setEntity((HttpEntity)body);
                if (!response.containsHeader("Last-Modified")) {
                    response.addHeader("Last-Modified", DateUtils.formatDate((Date)new Date(file.lastModified())));
                }
                NHttpFileServer.debug(conn + ": serving file " + file.getPath());
            }
        }

        public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
            return new BasicAsyncRequestConsumer();
        }
    }
}

