/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.junit.Test;

public class ProviderRenameTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.RENAME};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    private void moveFile(FileObject scratchFolder, FileObject file, String content) throws FileSystemException, Exception {
        FileObject fileMove = scratchFolder.resolveFile("file1move.txt");
        ProviderRenameTests.assertFalse((boolean)fileMove.exists());
        file.moveTo(fileMove);
        ProviderRenameTests.assertFalse((boolean)file.exists());
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        this.assertSameContent(content, fileMove);
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        ProviderRenameTests.assertTrue((boolean)fileMove.delete());
    }

    private String createTestFile(FileObject file) throws FileSystemException, IOException, UnsupportedEncodingException, Exception {
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        return "Here is some sample content for the file.  Blah Blah Blah.";
    }

    @Test
    public void testRenameFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderRenameTests.assertFalse((boolean)file.exists());
        String content = this.createTestFile(file);
        this.moveFile(scratchFolder, file, content);
    }

    @Test
    public void testRenameFileIntoEmptyFolder() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderRenameTests.assertFalse((boolean)file.exists());
        String content = this.createTestFile(file);
        FileObject destFolder = scratchFolder.resolveFile("empty-target-folder");
        destFolder.createFolder();
        ProviderRenameTests.assertTrue((String)"new destination must be folder", (boolean)destFolder.getType().hasChildren());
        ProviderRenameTests.assertEquals((String)"new destination must be emty", (int)0, (int)destFolder.getChildren().length);
        this.moveFile(destFolder, file, content);
    }

    @Test
    public void testRenameFileAndLeaveFolderEmpty() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject folder = scratchFolder.resolveFile("folder");
        folder.createFolder();
        ProviderRenameTests.assertTrue((boolean)folder.exists());
        FileObject file = folder.resolveFile("file1.txt");
        ProviderRenameTests.assertFalse((boolean)file.exists());
        String content = this.createTestFile(file);
        this.moveFile(scratchFolder, file, content);
        ProviderRenameTests.assertEquals((int)0, (int)folder.getChildren().length);
    }
}

