/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.AgeFileFilter;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AgeFileFilterTest
extends BaseFilterTest {
    private static final long DAY_MILLIS = 86400000L;
    private static final long NOW_MILLIS = System.currentTimeMillis();
    private static final long TWO_DAYS_AGO_MILLIS = NOW_MILLIS - 172800000L;
    private static final long TWO_DAYS_LATER_MILLIS = NOW_MILLIS + 172800000L;
    private static File testDir;
    private static File oldFile;
    private static FileSelectInfo oldFileInfo;
    private static File newFile;
    private static FileSelectInfo newFileInfo;
    private static File currentFile;
    private static FileSelectInfo currentFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = AgeFileFilterTest.getTestDir(AgeFileFilterTest.class.getName());
        oldFile = new File(testDir, "old.txt");
        FileUtils.touch((File)oldFile);
        oldFile.setLastModified(TWO_DAYS_AGO_MILLIS);
        oldFileInfo = AgeFileFilterTest.createFileSelectInfo(oldFile);
        currentFile = new File(testDir, "current.txt");
        FileUtils.touch((File)currentFile);
        currentFile.setLastModified(NOW_MILLIS);
        currentFileInfo = AgeFileFilterTest.createFileSelectInfo(currentFile);
        newFile = new File(testDir, "new.txt");
        FileUtils.touch((File)newFile);
        newFile.setLastModified(TWO_DAYS_LATER_MILLIS);
        newFileInfo = AgeFileFilterTest.createFileSelectInfo(newFile);
        zipFile = new File(AgeFileFilterTest.getTempDir(), AgeFileFilterTest.class.getName() + ".zip");
        AgeFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = AgeFileFilterTest.getZipFileObject(zipFile);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        newFileInfo = null;
        newFile = null;
        currentFileInfo = null;
        currentFile = null;
        oldFileInfo = null;
        oldFile = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @Test
    public void testAgeFileFilterDate() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(new Date());
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
    }

    @Test
    public void testAgeFileFilterDateBoolean() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(new Date(), true);
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
        testee = new AgeFileFilter(new Date(), false);
        Assert.assertFalse((boolean)testee.accept(oldFileInfo));
        Assert.assertFalse((boolean)testee.accept(currentFileInfo));
        Assert.assertTrue((boolean)testee.accept(newFileInfo));
    }

    @Test
    public void testAgeFileFilterFile() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(currentFileInfo.getFile());
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
    }

    @Test
    public void testAgeFileFilterFileBoolean() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(currentFileInfo.getFile(), true);
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
        testee = new AgeFileFilter(currentFileInfo.getFile(), false);
        Assert.assertFalse((boolean)testee.accept(oldFileInfo));
        Assert.assertFalse((boolean)testee.accept(currentFileInfo));
        Assert.assertTrue((boolean)testee.accept(newFileInfo));
    }

    @Test
    public void testAgeFileFilterLong() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(NOW_MILLIS);
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
    }

    @Test
    public void testAgeFileFilterLongBoolean() throws FileSystemException {
        AgeFileFilter testee = new AgeFileFilter(NOW_MILLIS, true);
        Assert.assertTrue((boolean)testee.accept(oldFileInfo));
        Assert.assertTrue((boolean)testee.accept(currentFileInfo));
        Assert.assertFalse((boolean)testee.accept(newFileInfo));
        testee = new AgeFileFilter(NOW_MILLIS, false);
        Assert.assertFalse((boolean)testee.accept(oldFileInfo));
        Assert.assertFalse((boolean)testee.accept(currentFileInfo));
        Assert.assertTrue((boolean)testee.accept(newFileInfo));
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new AgeFileFilter(NOW_MILLIS, true)));
        this.assertContains(files, oldFile.getName(), currentFile.getName());
        Assert.assertEquals((long)2L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new AgeFileFilter(NOW_MILLIS, false)));
        this.assertContains(files, newFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
    }
}

