/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;

public abstract class BaseFilterTest {
    protected static FileSelectInfo createFileSelectInfo(File file) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            final FileObject fileObject = fsManager.toFileObject(file);
            return new FileSelectInfo(){

                public FileObject getFile() {
                    return fileObject;
                }

                public int getDepth() {
                    return 0;
                }

                public FileObject getBaseFolder() {
                    try {
                        return fileObject.getParent();
                    }
                    catch (FileSystemException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                public String toString() {
                    return Objects.toString(fileObject);
                }
            };
        }
        catch (FileSystemException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static FileObject getZipFileObject(File file) throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        return fsManager.resolveFile("zip:" + file.toURI());
    }

    protected void assertContains(FileObject[] files, String ... fileNames) {
        for (String fileName : fileNames) {
            if (this.find(files, fileName)) continue;
            Assert.fail((String)("File '" + fileName + "' not found in: " + Arrays.asList(files)));
        }
    }

    private boolean find(FileObject[] files, String fileName) {
        for (FileObject file : files) {
            String name = file.getName().getBaseName();
            if (!name.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    protected static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    protected static File getTestDir(String name) {
        return new File(BaseFilterTest.getTempDir(), name);
    }

    protected static void assertContains(List<?> list, Object ... objects) {
        for (Object obj : objects) {
            Assert.assertTrue((String)("Couldn't find " + obj + " in " + Arrays.asList(objects)), (list.indexOf(obj) > -1 ? 1 : 0) != 0);
        }
    }

    protected static void assertContainsOnly(List<?> list, Object ... objects) {
        for (Object obj : objects) {
            Assert.assertTrue((String)("Couldn't find " + obj + " in " + Arrays.asList(objects)), (list.indexOf(obj) > -1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)objects.length, (long)list.size());
    }

    private static void zipFile(File srcFile, String destPath, ZipOutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));){
            int len;
            ZipEntry zipEntry = new ZipEntry(BaseFilterTest.concatPathAndFilename(destPath, srcFile.getName(), File.separator));
            zipEntry.setTime(srcFile.lastModified());
            out.putNextEntry(zipEntry);
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
    }

    private static void zipDir(File srcDir, FileFilter filter, String destPath, ZipOutputStream out) throws IOException {
        File[] files;
        for (File file : files = BaseFilterTest.listFiles(srcDir, filter)) {
            if (file.isDirectory()) {
                BaseFilterTest.zipDir(file, filter, BaseFilterTest.concatPathAndFilename(destPath, file.getName(), File.separator), out);
                continue;
            }
            BaseFilterTest.zipFile(file, destPath, out);
        }
    }

    public static void zipDir(File srcDir, FileFilter filter, String destPath, File destFile) throws IOException {
        if (srcDir == null) {
            throw new IllegalArgumentException("srcDir cannot be null");
        }
        if (!srcDir.exists()) {
            throw new IllegalArgumentException("srcDir does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("srcDir is not a directory");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("destFile cannot be null");
        }
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));){
            BaseFilterTest.zipDir(srcDir, filter, destPath, out);
        }
    }

    public static void zipDir(File srcDir, String destPath, File destFile) throws IOException {
        BaseFilterTest.zipDir(srcDir, null, destPath, destFile);
    }

    public static String concatPathAndFilename(String path, String fileName, String separator) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name cannot be null");
        }
        if (fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("file name cannot be empty");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        if (separator.trim().isEmpty()) {
            throw new IllegalArgumentException("separator cannot be empty");
        }
        if (path == null) {
            return fileName;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.isEmpty()) {
            return fileName;
        }
        String trimmedFilename = fileName.trim();
        if (trimmedPath.endsWith(separator)) {
            return trimmedPath + trimmedFilename;
        }
        return trimmedPath + separator + trimmedFilename;
    }

    private static File[] listFiles(File srcDir, FileFilter filter) {
        File[] files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        return files;
    }
}

