/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class DefaultFileMonitorTest {
    private static final int DELAY_MILLIS = 100;
    private FileSystemManager fsManager;
    private File testDir;
    private volatile Status changeStatus;
    private File testFile;

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
    }

    @Before
    public void setUp() throws Exception {
        this.fsManager = VFS.getManager();
        this.testDir = AbstractVfsTestCase.getTestDirectoryFile();
        this.changeStatus = null;
        this.testFile = new File(this.testDir, "testReload.properties");
        if (this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null && !this.testFile.delete()) {
            this.testFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreated() throws Exception {
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"Incorrect event", (Object)((Object)Status.CREATED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileDeleted() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.testFile.delete();
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"Incorrect event", (Object)((Object)Status.DELETED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileModified() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                Thread.sleep(1000L);
                long valueMillis = System.currentTimeMillis();
                boolean rcMillis = this.testFile.setLastModified(valueMillis);
                Assert.assertTrue((String)"setLastModified succeeded", (boolean)rcMillis);
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"Incorrect event", (Object)((Object)Status.CHANGED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileRecreated() throws Exception {
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.changeStatus)), (Object)((Object)Status.CREATED), (Object)((Object)this.changeStatus));
                this.changeStatus = null;
                this.testFile.delete();
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.changeStatus)), (Object)((Object)Status.DELETED), (Object)((Object)this.changeStatus));
                this.changeStatus = null;
                Thread.sleep(500L);
                monitor.addFile(fileObject);
                this.writeToFile(this.testFile);
                Thread.sleep(1000L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.changeStatus)), (Object)((Object)Status.CREATED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildFileRecreated() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObj = this.fsManager.resolveFile(this.testDir.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(2000L);
            monitor.setRecursive(true);
            monitor.addFile(fileObj);
            monitor.start();
            try {
                this.changeStatus = null;
                Thread.sleep(500L);
                this.testFile.delete();
                Thread.sleep(3000L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.changeStatus)), (Object)((Object)Status.DELETED), (Object)((Object)this.changeStatus));
                this.changeStatus = null;
                Thread.sleep(500L);
                this.writeToFile(this.testFile);
                Thread.sleep(3000L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.changeStatus)), (Object)((Object)Status.CREATED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildFileDeletedWithoutRecursiveChecking() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fsManager.resolveFile(this.testDir.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(2000L);
            monitor.setRecursive(false);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.changeStatus = null;
                Thread.sleep(500L);
                this.testFile.delete();
                Thread.sleep(3000L);
                Assert.assertEquals((String)"Event should not have occurred", null, (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileMonitorRestarted() throws Exception {
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(500L);
            }
            finally {
                monitor.stop();
            }
            monitor.start();
            try {
                this.testFile.delete();
                Thread.sleep(500L);
                Assert.assertTrue((String)"No event occurred", (this.changeStatus != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"Incorrect event", (Object)((Object)Status.DELETED), (Object)((Object)this.changeStatus));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    @Test
    public void ignore_testAddRemove() throws Exception {
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toString());){
            CountingListener listener = new CountingListener();
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)listener);
            monitor.setDelay(100L);
            try {
                monitor.addFile(fileObject);
                monitor.removeFile(fileObject);
                monitor.addFile(fileObject);
                monitor.start();
                this.writeToFile(this.testFile);
                Thread.sleep(300L);
                Assert.assertEquals((String)"Created event is only fired once", (long)1L, (long)listener.created.get());
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    @Test
    public void ignore_testStartStop() throws Exception {
        try (FileObject fileObject = this.fsManager.resolveFile(this.testFile.toURI().toString());){
            CountingListener stoppedListener = new CountingListener();
            DefaultFileMonitor stoppedMonitor = new DefaultFileMonitor((FileListener)stoppedListener);
            stoppedMonitor.start();
            try {
                stoppedMonitor.addFile(fileObject);
            }
            finally {
                stoppedMonitor.stop();
            }
            CountingListener activeListener = new CountingListener();
            DefaultFileMonitor activeMonitor = new DefaultFileMonitor((FileListener)activeListener);
            activeMonitor.setDelay(100L);
            activeMonitor.addFile(fileObject);
            activeMonitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(1000L);
                Assert.assertEquals((String)"The listener of the active monitor received one created event", (long)1L, (long)activeListener.created.get());
                Assert.assertEquals((String)"The listener of the stopped monitor received no events", (long)0L, (long)stoppedListener.created.get());
            }
            finally {
                activeMonitor.stop();
            }
        }
    }

    private void writeToFile(File file) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            out.write("string=value1");
        }
    }

    private class TestFileListener
    implements FileListener {
        private TestFileListener() {
        }

        public void fileChanged(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = Status.CHANGED;
        }

        public void fileDeleted(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = Status.DELETED;
        }

        public void fileCreated(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.changeStatus = Status.CREATED;
        }
    }

    private static enum Status {
        CHANGED,
        DELETED,
        CREATED;

    }

    private static class CountingListener
    implements FileListener {
        private final AtomicLong created = new AtomicLong();

        private CountingListener() {
        }

        public void fileCreated(FileChangeEvent event) {
            this.created.incrementAndGet();
        }

        public void fileDeleted(FileChangeEvent event) {
            throw new UnsupportedOperationException();
        }

        public void fileChanged(FileChangeEvent event) {
            throw new UnsupportedOperationException();
        }
    }
}

