/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.NullFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultFileSystemManagerTest {
    @Test
    public void test_close() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            VFS.setManager((FileSystemManager)fileSystemManager);
            VFS.setManager(null);
        }
        Assert.assertNotNull((Object)VFS.getManager());
        Assert.assertFalse((boolean)VFS.getManager().resolveFile(Paths.get("DoesNotExist.not", new String[0]).toUri()).exists());
    }

    @Test
    public void testAddAndRemoveProvider() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            fileSystemManager.setFilesCache((FilesCache)new NullFilesCache());
            fileSystemManager.setCacheStrategy(CacheStrategy.MANUAL);
            RamFileProvider provider = (RamFileProvider)Mockito.spy((Object)new RamFileProvider());
            fileSystemManager.addProvider("ram1", (FileProvider)provider);
            fileSystemManager.addProvider("ram2", (FileProvider)provider);
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram1:///"));
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram1");
            ((RamFileProvider)Mockito.verify((Object)provider, (VerificationMode)Mockito.never())).close();
            Assert.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram1:///"));
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram2");
            ((RamFileProvider)Mockito.verify((Object)provider)).close();
            Assert.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram2:///"));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testResolveFileAbsoluteThrows() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((File)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileNameNull() throws FileSystemException {
        VFS.getManager().resolveName((FileName)null, "../");
    }

    @Test
    public void testResolveFileObjectNullAbsolute() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((FileObject)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileObjectRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((FileObject)null, "relativePath");
    }

    @Test(expected=NullPointerException.class)
    public void testResolveFileRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((File)null, "relativePath");
    }
}

