/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConversionTestCase {
    @Test
    @Ignore
    public void testFileNameWithSpaces() throws URISyntaxException, IOException {
        File file = new File("target", "a name.txt");
        String fileURL = file.toURI().toURL().toExternalForm();
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(file.toURI().getPath()));
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fileURL).toURI().getPath()));
        FileSystemManager manager = VFS.getManager();
        FileObject fo = manager.resolveFile(fileURL);
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fo.getURL().toExternalForm()).toURI().getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testFileNameWithCharacters() throws URISyntaxException, IOException {
        File file = new File("target", "+# %&.txt");
        String fileURL = file.toURI().toURL().toExternalForm();
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(file.toURI().getPath()));
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fileURL).toURI().getPath()));
        try {
            new FileOutputStream(file).close();
            Assert.assertTrue((boolean)file.exists());
            FileSystemManager manager = VFS.getManager();
            FileObject fo = manager.resolveFile(fileURL);
            Assert.assertTrue((boolean)fo.exists());
            Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)new File(new URL(fo.getURL().toExternalForm()).toURI().getPath()));
        }
        finally {
            file.delete();
        }
    }
}

