/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;

public class NestedTarTestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedTarTestCase(), true);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
        manager.addExtensionMap("tar", "tar");
        manager.addMimeTypeMap("application/x-tar", "tar");
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        FileSystemOptions opts = new FileSystemOptions();
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator("domain", null, null));
        String tarFilePath = AbstractVfsTestCase.getTestResource("nested.tar").getAbsolutePath();
        String uri = "tar:file:" + tarFilePath + "!/test.tar";
        FileObject tarFile = manager.resolveFile(uri, opts);
        FileObject nestedFS = manager.createFileSystem(tarFile);
        return nestedFS.resolveFile("/");
    }
}

