/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileObjectSortTestCase {
    private static final int SIZE = 100;
    private static FileSystem VfsFileSystem;
    private static FileObject[] SortedArray;
    private static FileObject[] UnSortedArray;

    private static FileObject resolveFile(FileSystem fs, int i) throws FileSystemException {
        return fs.resolveFile(String.format("%010d", i));
    }

    @BeforeClass
    public static void setUpClass() throws FileSystemException {
        int i;
        VfsFileSystem = VFS.getManager().createVirtualFileSystem("vfs://").getFileSystem();
        SortedArray = new FileObject[100];
        for (i = 0; i < 100; ++i) {
            FileObjectSortTestCase.SortedArray[i] = FileObjectSortTestCase.resolveFile(VfsFileSystem, i);
        }
        UnSortedArray = new FileObject[100];
        for (i = 0; i < 100; ++i) {
            FileObjectSortTestCase.UnSortedArray[i] = FileObjectSortTestCase.resolveFile(VfsFileSystem, 100 - i - 1);
        }
    }

    @Test
    public void testSortArrayIgnoreCase() throws FileSystemException {
        FileObject file1 = VfsFileSystem.resolveFile("A1");
        FileObject file2 = VfsFileSystem.resolveFile("a2");
        FileObject file3 = VfsFileSystem.resolveFile("A3");
        Object[] actualArray = new FileObject[]{file3, file1, file2, file1, file2};
        Object[] expectedArray = new FileObject[]{file1, file1, file2, file2, file3};
        Arrays.sort(actualArray);
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])actualArray);
    }

    @Test
    public void testSortArrayMoveAll() throws FileSystemException {
        Object[] actualArray = (FileObject[])UnSortedArray.clone();
        Assert.assertFalse((boolean)Arrays.equals(UnSortedArray, SortedArray));
        Arrays.sort(actualArray);
        Assert.assertArrayEquals((Object[])SortedArray, (Object[])actualArray);
    }

    @Test
    public void testSortArrayMoveNone() throws FileSystemException {
        Object[] actualArray = (FileObject[])SortedArray.clone();
        Arrays.sort(actualArray);
        Assert.assertArrayEquals((Object[])SortedArray, (Object[])actualArray);
    }

    @Test
    public void testSortListMoveAll() throws FileSystemException {
        List<FileObject> actualList = Arrays.asList(UnSortedArray);
        List<FileObject> expectedSortedList = Arrays.asList(SortedArray);
        Assert.assertNotEquals(actualList, expectedSortedList);
        Collections.sort(actualList);
        Assert.assertEquals(actualList, expectedSortedList);
    }

    @Test
    public void testSortListMoveNone() throws FileSystemException {
        List<FileObject> actualList = Arrays.asList(SortedArray);
        List<FileObject> expectedSortedList = Arrays.asList(SortedArray);
        Collections.sort(actualList);
        Assert.assertEquals(actualList, expectedSortedList);
    }
}

