/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.junit.Test;

public class GenericFileNameTestCase
extends AbstractVfsTestCase {
    @Test
    public void testParseUri() throws Exception {
        URLFileNameParser urlParser = new URLFileNameParser(21);
        GenericFileName name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname/file");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertNull((Object)name.getUserName());
        GenericFileNameTestCase.assertNull((Object)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)21, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((int)name.getDefaultPort(), (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/file", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname/file", (String)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname:9090/file");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertNull((Object)name.getUserName());
        GenericFileNameTestCase.assertNull((Object)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)9090, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/file", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname:9090/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname:9090/file", (String)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertNull((Object)name.getUserName());
        GenericFileNameTestCase.assertNull((Object)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)21, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://hostname/", (String)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://user@hostname/file");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertEquals((String)"user", (String)name.getUserName());
        GenericFileNameTestCase.assertNull((Object)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)21, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/file", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://user@hostname/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://user@hostname/file", (String)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://user:password@hostname/file");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertEquals((String)"user", (String)name.getUserName());
        GenericFileNameTestCase.assertEquals((String)"password", (String)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)21, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/file", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://user:password@hostname/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://user:password@hostname/file", (String)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://%75ser%3A:%40@hostname");
        GenericFileNameTestCase.assertEquals((String)"ftp", (String)name.getScheme());
        GenericFileNameTestCase.assertEquals((String)"user:", (String)name.getUserName());
        GenericFileNameTestCase.assertEquals((String)"@", (String)name.getPassword());
        GenericFileNameTestCase.assertEquals((String)"hostname", (String)name.getHostName());
        GenericFileNameTestCase.assertEquals((int)21, (int)name.getPort());
        GenericFileNameTestCase.assertEquals((String)"/", (String)name.getPath());
        GenericFileNameTestCase.assertEquals((String)"ftp://user%3a:%40@hostname/", (String)name.getRootURI());
        GenericFileNameTestCase.assertEquals((String)"ftp://user%3a:%40@hostname/", (String)name.getURI());
    }

    @Test
    public void testBadlyFormedUri() throws Exception {
        this.testBadlyFormedUri("ftp:", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp:/", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp:a", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp://", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://:21/file", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp:///file", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://host:", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:/file", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:port/file", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:90a", "vfs.provider/missing-hostname-path-sep.error");
        this.testBadlyFormedUri("ftp://host?a", "vfs.provider/missing-hostname-path-sep.error");
    }

    private void testBadlyFormedUri(String uri, String errorMsg) {
        try {
            new URLFileNameParser(80).parseUri(null, null, uri);
            GenericFileNameTestCase.fail();
        }
        catch (FileSystemException e) {
            GenericFileNameTestCase.assertSameMessage(errorMsg, uri, (Throwable)e);
        }
    }
}

